/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNetRestClient {
    private static final Logger log = LoggerFactory.getLogger(DNetRestClient.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private DNetRestClient() {
    }

    public static <T> T doGET(String url, Class<T> clazz) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return DNetRestClient.doHTTPRequest((HttpUriRequest)httpGet, clazz);
    }

    public static String doGET(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        return DNetRestClient.doHTTPRequest((HttpUriRequest)httpGet);
    }

    public static <V> String doPOST(String url, V objParam) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (objParam != null) {
            StringEntity entity = new StringEntity(mapper.writeValueAsString(objParam));
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
        }
        return DNetRestClient.doHTTPRequest((HttpUriRequest)httpPost);
    }

    public static <T, V> T doPOST(String url, V objParam, Class<T> clazz) throws IOException {
        return (T)mapper.readValue(DNetRestClient.doPOST(url, objParam), clazz);
    }

    private static String doHTTPRequest(HttpUriRequest r) throws IOException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            log.info("performing HTTP request, method {} on URI {}", (Object)r.getMethod(), (Object)r.getURI().toString());
            log.info("request headers: {}", (Object)Arrays.asList(r.getAllHeaders()).stream().map(h -> h.getName() + ":" + h.getValue()).collect(Collectors.joining(",")));
            String string = IOUtils.toString((InputStream)client.execute(r).getEntity().getContent());
            return string;
        }
    }

    private static <T> T doHTTPRequest(HttpUriRequest r, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(DNetRestClient.doHTTPRequest(r), clazz);
    }
}

