/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

abstract class AbstractSparkAction
implements Serializable {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public ArgumentApplicationParser parser;
    public SparkSession spark;

    public AbstractSparkAction(ArgumentApplicationParser parser, SparkSession spark) {
        this.parser = parser;
        this.spark = spark;
    }

    public List<DedupConfig> getConfigurations(ISLookUpService isLookUpService, String orchestrator) throws ISLookUpException, DocumentException, IOException {
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ACTION_SET/@id = '%s']", orchestrator);
        String orchestratorProfile = isLookUpService.getResourceProfileByQuery(xquery);
        Document doc = new SAXReader().read((Reader)new StringReader(orchestratorProfile));
        String actionSetId = doc.valueOf("//DEDUPLICATION/ACTION_SET/@id");
        ArrayList<DedupConfig> configurations = new ArrayList<DedupConfig>();
        for (Object o : doc.selectNodes("//SCAN_SEQUENCE/SCAN")) {
            configurations.add(this.loadConfig(isLookUpService, actionSetId, o));
        }
        return configurations;
    }

    private DedupConfig loadConfig(ISLookUpService isLookUpService, String actionSetId, Object o) throws ISLookUpException, IOException {
        Element s = (Element)o;
        String configProfileId = s.attributeValue("id");
        String conf = isLookUpService.getResourceProfileByQuery(String.format("for $x in /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '%s'] return $x//DEDUPLICATION/text()", configProfileId));
        DedupConfig dedupConfig = (DedupConfig)new ObjectMapper().readValue(conf, DedupConfig.class);
        dedupConfig.getPace().initModel();
        dedupConfig.getPace().initTranslationMap();
        dedupConfig.getWf().setConfigurationId(actionSetId);
        return dedupConfig;
    }

    abstract void run(ISLookUpService var1) throws DocumentException, IOException, ISLookUpException;

    protected static SparkSession getSparkSession(SparkConf conf) {
        return SparkSession.builder().config(conf).getOrCreate();
    }

    protected static <T> void save(Dataset<T> dataset, String outPath, SaveMode mode) {
        dataset.write().option("compression", "gzip").mode(mode).json(outPath);
    }

    protected static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

