/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.wcohen.ss.JaroWinkler;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.pace.model.Person;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import scala.Tuple2;

public class AuthorMerger {
    private static final Double THRESHOLD = 0.95;

    public static List<Author> merge(List<List<Author>> authors) {
        authors.sort((o1, o2) -> -Integer.compare(AuthorMerger.countAuthorsPids(o1), AuthorMerger.countAuthorsPids(o2)));
        List<Author> author = new ArrayList<Author>();
        for (List<Author> a : authors) {
            author = AuthorMerger.mergeAuthor(author, a);
        }
        return author;
    }

    public static List<Author> mergeAuthor(List<Author> a, List<Author> b) {
        List<Author> enrich;
        List<Author> base;
        int pa = AuthorMerger.countAuthorsPids(a);
        int pb = AuthorMerger.countAuthorsPids(b);
        int sa = AuthorMerger.authorsSize(a);
        int sb = AuthorMerger.authorsSize(b);
        if (pa == pb) {
            base = sa > sb ? a : b;
            enrich = sa > sb ? b : a;
        } else {
            base = pa > pb ? a : b;
            enrich = pa > pb ? b : a;
        }
        AuthorMerger.enrichPidFromList(base, enrich);
        return base;
    }

    private static void enrichPidFromList(List<Author> base, List<Author> enrich) {
        if (base == null || enrich == null) {
            return;
        }
        Map<String, Author> basePidAuthorMap = base.stream().filter(a -> a.getPid() != null && a.getPid().size() > 0).flatMap(a -> a.getPid().stream().map(p -> new Tuple2((Object)AuthorMerger.pidToComparableString(p), a))).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2, (x1, x2) -> x1));
        List<Tuple2> pidToEnrich = enrich.stream().filter(a -> a.getPid() != null && a.getPid().size() > 0).flatMap(a -> a.getPid().stream().filter(p -> !basePidAuthorMap.containsKey(AuthorMerger.pidToComparableString(p))).map(p -> new Tuple2(p, a))).collect(Collectors.toList());
        pidToEnrich.forEach(a -> {
            Optional<Tuple2> simAuthor = base.stream().map(ba -> new Tuple2((Object)AuthorMerger.sim(ba, (Author)a._2()), ba)).max(Comparator.comparing(Tuple2::_1));
            if (simAuthor.isPresent()) {
                double th = THRESHOLD;
                if (((Author)simAuthor.get()._2()).getSurname() != null && ((Author)simAuthor.get()._2()).getSurname().length() <= 3) {
                    th = 0.99;
                }
                if ((Double)simAuthor.get()._1() > th) {
                    Author r = (Author)simAuthor.get()._2();
                    if (r.getPid() == null) {
                        r.setPid(new ArrayList());
                    }
                    r.getPid().add(a._1());
                }
            }
        });
    }

    public static String pidToComparableString(StructuredProperty pid) {
        return (pid.getQualifier() != null ? (pid.getQualifier().getClassid() != null ? pid.getQualifier().getClassid().toLowerCase() : "") : "") + (pid.getValue() != null ? pid.getValue().toLowerCase() : "");
    }

    public static int countAuthorsPids(List<Author> authors) {
        if (authors == null) {
            return 0;
        }
        return (int)authors.stream().filter(AuthorMerger::hasPid).count();
    }

    private static int authorsSize(List<Author> authors) {
        if (authors == null) {
            return 0;
        }
        return authors.size();
    }

    private static Double sim(Author a, Author b) {
        Person pa = AuthorMerger.parse(a);
        Person pb = AuthorMerger.parse(b);
        if (pa.isAccurate() & pb.isAccurate()) {
            return new JaroWinkler().score(AuthorMerger.normalize(pa.getSurnameString()), AuthorMerger.normalize(pb.getSurnameString())) * 0.5 + new JaroWinkler().score(AuthorMerger.normalize(pa.getNameString()), AuthorMerger.normalize(pb.getNameString())) * 0.5;
        }
        return new JaroWinkler().score(AuthorMerger.normalize(pa.getNormalisedFullname()), AuthorMerger.normalize(pb.getNormalisedFullname()));
    }

    private static boolean hasPid(Author a) {
        if (a == null || a.getPid() == null || a.getPid().size() == 0) {
            return false;
        }
        return a.getPid().stream().anyMatch(p -> p != null && StringUtils.isNotBlank((CharSequence)p.getValue()));
    }

    private static Person parse(Author author) {
        if (StringUtils.isNotBlank((CharSequence)author.getSurname())) {
            return new Person(author.getSurname() + ", " + author.getName(), false);
        }
        return new Person(author.getFullname(), false);
    }

    private static String normalize(String s) {
        return AuthorMerger.nfd(s).toLowerCase().replaceAll("(\\W)+", " ").replaceAll("(\\p{InCombiningDiacriticalMarks})+", " ").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim();
    }

    private static String nfd(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }
}

