/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IdGenerator
implements Serializable {
    public static <T extends OafEntity> String generate(List<Identifier<T>> pids, String defaultID) {
        if (pids == null || pids.size() == 0) {
            return defaultID;
        }
        Identifier bp = (Identifier)pids.stream().min(Identifier::compareTo).get();
        String prefix = StringUtils.substringBefore((String)bp.getOriginalID(), (String)"|");
        String ns = StringUtils.substringBefore((String)StringUtils.substringAfter((String)bp.getOriginalID(), (String)"|"), (String)"::");
        String suffix = StringUtils.substringAfter((String)bp.getOriginalID(), (String)"::");
        String pidType = StringUtils.substringBefore((String)ns, (String)"_");
        if (PidType.isValid((String)pidType)) {
            return prefix + "|" + IdGenerator.dedupify(ns) + "::" + suffix;
        }
        return prefix + "|dedup_wf_001::" + suffix;
    }

    private static String dedupify(String ns) {
        StringBuilder prefix = PidType.valueOf((String)StringUtils.substringBefore((String)ns, (String)"_")) == PidType.openorgs ? new StringBuilder(StringUtils.substringBefore((String)ns, (String)"_")) : new StringBuilder(StringUtils.substringBefore((String)ns, (String)"_")).append("_dedup");
        while (prefix.length() < 12) {
            prefix.append("_");
        }
        return prefix.substring(0, 12);
    }
}

