/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchEntitiesSparkJob {
    private static final Logger log = LoggerFactory.getLogger(DispatchEntitiesSparkJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)Objects.requireNonNull(DispatchEntitiesSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/dispatch_entities_parameters.json")));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String graphTableClassName = parser.get("graphTableClassName");
        log.info("graphTableClassName: {}", (Object)graphTableClassName);
        Class<?> entityClazz = Class.forName(graphTableClassName);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            HdfsSupport.remove((String)outputPath, (Configuration)spark.sparkContext().hadoopConfiguration());
            DispatchEntitiesSparkJob.dispatchEntities(spark, inputPath, entityClazz, outputPath);
        });
    }

    private static <T extends Oaf> void dispatchEntities(SparkSession spark, String inputPath, Class<T> clazz, String outputPath) {
        spark.read().textFile(inputPath).filter((FilterFunction & Serializable)s -> DispatchEntitiesSparkJob.isEntityType(s, clazz)).map((MapFunction & Serializable)s -> StringUtils.substringAfter((String)s, (String)"|"), Encoders.STRING()).map((MapFunction & Serializable)value -> (Oaf)OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    private static <T extends Oaf> boolean isEntityType(String s, Class<T> clazz) {
        return StringUtils.substringBefore((String)s, (String)"|").equals(clazz.getName());
    }
}

