/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.SparkCreateSimRels;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import scala.Tuple2;

public class SparkWhitelistSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateSimRels.class);
    private static final String WHITELIST_SEPARATOR = "####";

    public SparkWhitelistSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/whitelistSimRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkWhitelistSimRels(parser, SparkWhitelistSimRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException, SAXException {
        String graphBasePath = this.parser.get("graphBasePath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        String whiteListPath = this.parser.get("whiteListPath");
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("whiteListPath: '{}'", (Object)whiteListPath);
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        Dataset whiteListRels = this.spark.createDataset(sc.textFile(whiteListPath).filter((Function & Serializable)s -> s.contains(WHITELIST_SEPARATOR) && s.split(WHITELIST_SEPARATOR).length == 2).map((Function & Serializable)s -> new Tuple2((Object)s.split(WHITELIST_SEPARATOR)[0], (Object)s.split(WHITELIST_SEPARATOR)[1])).rdd(), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String entity = dedupConf.getWf().getEntityType();
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Adding whitelist simrels for: '{}'", (Object)subEntity);
            String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity);
            Dataset entities = this.spark.createDataset(sc.textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).repartition(numPartitions).mapToPair((PairFunction & Serializable)s -> {
                MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConf, (String)s);
                return new Tuple2((Object)d.getIdentifier(), (Object)"present");
            }).rdd(), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
            Dataset whiteListRels1 = whiteListRels.joinWith(entities, whiteListRels.col("_1").equalTo((Object)entities.col("_1")), "inner").map(Tuple2::_1, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
            Dataset whiteListRels2 = whiteListRels1.joinWith(entities, whiteListRels1.col("_2").equalTo((Object)entities.col("_1")), "inner").map(Tuple2::_1, Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
            Dataset whiteListSimRels = whiteListRels2.map((MapFunction & Serializable)r -> DedupUtility.createSimRel((String)r._1(), (String)r._2(), entity), Encoders.bean(Relation.class));
            SparkWhitelistSimRels.saveParquet(whiteListSimRels, outputPath, SaveMode.Append);
        }
    }
}

