/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup.model;

import com.google.common.collect.Sets;
import eu.dnetlib.dhp.oa.dedup.DatePicker;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidComparator;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Identifier<T extends OafEntity>
implements Serializable,
Comparable<Identifier<T>> {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String BASE_DATE = "2000-01-01";
    private T entity;
    private Date date = null;

    public static <T extends OafEntity> Identifier<T> newInstance(T entity) {
        return new Identifier<T>(entity);
    }

    public Identifier(T entity) {
        this.entity = entity;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public Date getDate() {
        Result result;
        if (Objects.nonNull(this.date)) {
            return this.date;
        }
        String sDate = BASE_DATE;
        if (ModelSupport.isSubClass(this.getEntity(), Result.class).booleanValue() && Identifier.isWellformed((Field<String>)(result = (Result)this.getEntity()).getDateofacceptance())) {
            sDate = (String)result.getDateofacceptance().getValue();
        }
        try {
            this.date = new SimpleDateFormat(DATE_FORMAT).parse(sDate);
            return this.date;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("cannot parse date: '%s' from record: '%s'", sDate, this.entity.getId()));
        }
    }

    private static boolean isWellformed(Field<String> date) {
        return date != null && StringUtils.isNotBlank((CharSequence)((CharSequence)date.getValue())) && ((String)date.getValue()).matches("^(\\d{4})-(\\d{2})-(\\d{2})") && DatePicker.inRange((String)date.getValue());
    }

    public List<KeyValue> getCollectedFrom() {
        return this.entity.getCollectedfrom();
    }

    public EntityType getEntityType() {
        return EntityType.fromClass(this.entity.getClass());
    }

    public String getOriginalID() {
        return this.entity.getId();
    }

    private PidType getPidType() {
        return PidType.tryValueOf((String)StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.entity.getId(), (String)"|"), (String)"_"));
    }

    @Override
    public int compareTo(Identifier<T> i) {
        Set lKeys = Optional.ofNullable(this.getCollectedFrom()).map(c -> c.stream().map(KeyValue::getKey).collect(Collectors.toSet())).orElse(Sets.newHashSet());
        Optional<List<KeyValue>> cf = Optional.ofNullable(i.getCollectedFrom());
        Set rKeys = cf.map(c -> c.stream().map(KeyValue::getKey).collect(Collectors.toSet())).orElse(Sets.newHashSet());
        if (this.getPidType().compareTo((Enum)super.getPidType()) == 0) {
            if (this.getEntityType() == EntityType.publication) {
                if (this.isFromDatasourceID(lKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && !this.isFromDatasourceID(rKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
                    return -1;
                }
                if (this.isFromDatasourceID(rKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && !this.isFromDatasourceID(lKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
                    return 1;
                }
            }
            if (this.getEntityType() == EntityType.dataset) {
                if (this.isFromDatasourceID(lKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254") && !this.isFromDatasourceID(rKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254")) {
                    return -1;
                }
                if (this.isFromDatasourceID(rKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254") && !this.isFromDatasourceID(lKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254")) {
                    return 1;
                }
            }
            if (this.getDate().compareTo(i.getDate()) == 0) {
                return this.getOriginalID().compareTo(i.getOriginalID());
            }
            return this.getDate().compareTo(i.getDate());
        }
        return new PidComparator(this.getEntity()).compare(this.toSP(this.getPidType()), this.toSP(super.getPidType()));
    }

    private StructuredProperty toSP(PidType pidType) {
        return OafMapperUtils.structuredProperty((String)"", (String)pidType.toString(), (String)pidType.toString(), (String)"", (String)"", (DataInfo)new DataInfo());
    }

    public boolean isFromDatasourceID(Set<String> collectedFrom, String dsId) {
        return collectedFrom.contains(dsId);
    }
}

