/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.pace.util.PaceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ConnectedComponent
implements Serializable {
    private String ccId;
    private Set<String> ids;
    private static final String CONNECTED_COMPONENT_ID_PREFIX = "connect_comp";

    public ConnectedComponent(Set<String> ids, int cut) {
        this.ids = ids;
        this.ccId = this.createDefaultID();
        if (cut > 0 && ids.size() > cut) {
            this.ids = ids.stream().filter(id -> !this.ccId.equalsIgnoreCase((String)id)).limit(cut - 1).collect(Collectors.toSet());
        }
    }

    public ConnectedComponent(String ccId, Set<String> ids) {
        this.ccId = ccId;
        this.ids = ids;
    }

    public String createDefaultID() {
        if (this.ids.size() > 1) {
            String s = this.getMin();
            String prefix = s.split("\\|")[0];
            this.ccId = prefix + "|" + CONNECTED_COMPONENT_ID_PREFIX + "::" + DHPUtils.md5((String)s);
            return this.ccId;
        }
        return this.ids.iterator().next();
    }

    @JsonIgnore
    public String getMin() {
        StringBuilder min = new StringBuilder();
        this.ids.forEach(id -> {
            if (StringUtils.isBlank((String)min.toString())) {
                min.append((String)id);
            } else if (min.toString().compareTo((String)id) > 0) {
                min.setLength(0);
                min.append((String)id);
            }
        });
        return min.toString();
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("Failed to create Json: ", (Throwable)e);
        }
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public void setIds(Set<String> ids) {
        this.ids = ids;
    }

    public String getCcId() {
        return this.ccId;
    }

    public void setCcId(String ccId) {
        this.ccId = ccId;
    }
}

