/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

abstract class AbstractSparkAction
implements Serializable {
    protected static final int NUM_PARTITIONS = 1000;
    protected static final int NUM_CONNECTIONS = 20;
    protected static final String TYPE_VALUE_SEPARATOR = "###";
    protected static final String SP_SEPARATOR = "@@@";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public final ArgumentApplicationParser parser;
    public final SparkSession spark;

    protected AbstractSparkAction(ArgumentApplicationParser parser, SparkSession spark) {
        this.parser = parser;
        this.spark = spark;
    }

    public List<DedupConfig> getConfigurations(ISLookUpService isLookUpService, String orchestrator) throws ISLookUpException, DocumentException, IOException, SAXException {
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ACTION_SET/@id = '%s']", orchestrator);
        String orchestratorProfile = isLookUpService.getResourceProfileByQuery(xquery);
        SAXReader reader = new SAXReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = reader.read((Reader)new StringReader(orchestratorProfile));
        String actionSetId = doc.valueOf("//DEDUPLICATION/ACTION_SET/@id");
        ArrayList<DedupConfig> configurations = new ArrayList<DedupConfig>();
        for (Object o : doc.selectNodes("//SCAN_SEQUENCE/SCAN")) {
            configurations.add(this.loadConfig(isLookUpService, actionSetId, o));
        }
        return configurations;
    }

    private DedupConfig loadConfig(ISLookUpService isLookUpService, String actionSetId, Object o) throws ISLookUpException, IOException {
        Element s = (Element)o;
        String configProfileId = s.attributeValue("id");
        String conf = isLookUpService.getResourceProfileByQuery(String.format("for $x in /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '%s'] return $x//DEDUPLICATION/text()", configProfileId));
        DedupConfig dedupConfig = DedupConfig.load((String)conf);
        dedupConfig.getWf().setConfigurationId(actionSetId);
        return dedupConfig;
    }

    abstract void run(ISLookUpService var1) throws DocumentException, IOException, ISLookUpException, SAXException;

    protected static SparkSession getSparkSession(SparkConf conf) {
        return SparkSession.builder().config(conf).getOrCreate();
    }

    protected static SparkSession getSparkWithHiveSession(SparkConf conf) {
        return SparkSession.builder().enableHiveSupport().config(conf).getOrCreate();
    }

    protected static <T> void save(Dataset<T> dataset, String outPath, SaveMode mode) {
        dataset.write().option("compression", "gzip").mode(mode).json(outPath);
    }

    protected static <T> void saveParquet(Dataset<T> dataset, String outPath, SaveMode mode) {
        dataset.write().option("compression", "gzip").mode(mode).parquet(outPath);
    }

    protected static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    protected static String structuredPropertyListToString(List<StructuredProperty> list) {
        return list.stream().filter(p -> p.getQualifier() != null).filter(p -> StringUtils.isNotBlank((CharSequence)p.getQualifier().getClassid())).filter(p -> StringUtils.isNotBlank((CharSequence)p.getValue())).map(p -> p.getValue() + TYPE_VALUE_SEPARATOR + p.getQualifier().getClassid()).collect(Collectors.joining(SP_SEPARATOR));
    }

    protected static MapFunction<String, Relation> patchRelFn() {
        return (MapFunction & Serializable)value -> {
            Relation rel = (Relation)OBJECT_MAPPER.readValue(value, Relation.class);
            if (rel.getDataInfo() == null) {
                rel.setDataInfo(new DataInfo());
            }
            return rel;
        };
    }

    protected boolean isOpenorgs(Relation rel) {
        return Optional.ofNullable(rel.getCollectedfrom()).map(c -> this.isCollectedFromOpenOrgs((List<KeyValue>)c)).orElse(false);
    }

    protected boolean isOpenorgsDedupRel(Relation rel) {
        return this.isOpenorgs(rel) && this.isOpenOrgsDedupMergeRelation(rel);
    }

    private boolean isCollectedFromOpenOrgs(List<KeyValue> c) {
        return c.stream().filter(Objects::nonNull).anyMatch(kv -> "OpenOrgs Database".equals(kv.getValue()));
    }

    private boolean isOpenOrgsDedupMergeRelation(Relation rel) {
        return "organizationOrganization".equals(rel.getRelType()) && "dedup".equals(rel.getSubRelType()) && ("isMergedIn".equals(rel.getRelClass()) || "merges".equals(rel.getRelClass()));
    }

    protected static Boolean parseECField(Field<String> field) {
        if (field == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)field.getValue())) || ((String)field.getValue()).equalsIgnoreCase("null")) {
            return null;
        }
        return ((String)field.getValue()).equalsIgnoreCase("true");
    }
}

