/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class DedupUtility {
    public static final String OPENORGS_ID_PREFIX = "openorgs____";
    public static final String CORDA_ID_PREFIX = "corda";

    private DedupUtility() {
    }

    public static String createDedupRecordPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_deduprecord", basePath, actionSetId, entityType);
    }

    public static String createEntityPath(String basePath, String entityType) {
        return String.format("%s/%s", basePath, entityType);
    }

    public static String createModelPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_model", basePath, actionSetId, entityType);
    }

    public static String createSimRelPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_simrel", basePath, actionSetId, entityType);
    }

    public static String createOpenorgsMergeRelsPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_openorgs_mergerels", basePath, actionSetId, entityType);
    }

    public static String createMergeRelPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_mergerel", basePath, actionSetId, entityType);
    }

    public static String createBlockStatsPath(String basePath, String actionSetId, String entityType) {
        return String.format("%s/%s/%s_blockstats", basePath, actionSetId, entityType);
    }

    public static List<DedupConfig> getConfigurations(String isLookUpUrl, String orchestrator) throws ISLookUpException, DocumentException, SAXException {
        ISLookUpService isLookUpService = ISLookupClientFactory.getLookUpService((String)isLookUpUrl);
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ACTION_SET/@id = '%s']", orchestrator);
        String orchestratorProfile = isLookUpService.getResourceProfileByQuery(xquery);
        SAXReader reader = new SAXReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = reader.read((Reader)new StringReader(orchestratorProfile));
        String actionSetId = doc.valueOf("//DEDUPLICATION/ACTION_SET/@id");
        ArrayList<DedupConfig> configurations = new ArrayList<DedupConfig>();
        for (Object o : doc.selectNodes("//SCAN_SEQUENCE/SCAN")) {
            configurations.add(DedupUtility.loadConfig(isLookUpService, actionSetId, o));
        }
        return configurations;
    }

    private static DedupConfig loadConfig(ISLookUpService isLookUpService, String actionSetId, Object o) throws ISLookUpException {
        Element s = (Element)o;
        String configProfileId = s.attributeValue("id");
        String conf = isLookUpService.getResourceProfileByQuery(String.format("for $x in /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '%s'] return $x//DEDUPLICATION/text()", configProfileId));
        DedupConfig dedupConfig = DedupConfig.load((String)conf);
        dedupConfig.getWf().setConfigurationId(actionSetId);
        return dedupConfig;
    }

    public static int compareOpenOrgIds(String o1, String o2) {
        if (o1.contains(OPENORGS_ID_PREFIX) && o2.contains(OPENORGS_ID_PREFIX)) {
            return o1.compareTo(o2);
        }
        if (o1.contains(CORDA_ID_PREFIX) && o2.contains(CORDA_ID_PREFIX)) {
            return o1.compareTo(o2);
        }
        if (o1.contains(OPENORGS_ID_PREFIX)) {
            return -1;
        }
        if (o2.contains(OPENORGS_ID_PREFIX)) {
            return 1;
        }
        if (o1.contains(CORDA_ID_PREFIX)) {
            return -1;
        }
        if (o2.contains(CORDA_ID_PREFIX)) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static Relation createSimRel(String source, String target, String entity) {
        Relation r = new Relation();
        r.setSource(source);
        r.setTarget(target);
        r.setSubRelType("dedupSimilarity");
        r.setRelClass("isSimilarTo");
        r.setDataInfo(new DataInfo());
        switch (entity) {
            case "result": {
                r.setRelType("resultResult");
                break;
            }
            case "organization": {
                r.setRelType("organizationOrganization");
                break;
            }
            default: {
                throw new IllegalArgumentException("unmanaged entity type: " + entity);
            }
        }
        return r;
    }
}

