/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IdGenerator
implements Serializable {
    public static <T extends OafEntity> String generate(List<? extends Identifier> pids, String defaultID) {
        if (pids == null || pids.isEmpty()) {
            return defaultID;
        }
        return IdGenerator.generateId(pids);
    }

    private static String generateId(List<? extends Identifier> pids) {
        Identifier bp = (Identifier)pids.stream().min(Identifier::compareTo).orElseThrow(() -> new IllegalStateException("unable to generate id"));
        return IdGenerator.generate(bp.getOriginalID());
    }

    public static String generate(String originalId) {
        String prefix = StringUtils.substringBefore((String)originalId, (String)"|");
        String ns = StringUtils.substringBefore((String)StringUtils.substringAfter((String)originalId, (String)"|"), (String)"::");
        String suffix = StringUtils.substringAfter((String)originalId, (String)"::");
        String pidType = StringUtils.substringBefore((String)ns, (String)"_");
        if (PidType.isValid((String)pidType)) {
            return prefix + "|" + IdGenerator.dedupify(ns) + "::" + suffix;
        }
        return prefix + "|dedup_wf_002::" + DHPUtils.md5((String)originalId);
    }

    private static String dedupify(String ns) {
        StringBuilder prefix = PidType.valueOf((String)StringUtils.substringBefore((String)ns, (String)"_")) == PidType.openorgs ? new StringBuilder(StringUtils.substringBefore((String)ns, (String)"_")) : new StringBuilder(StringUtils.substringBefore((String)ns, (String)"_")).append("_dedup");
        while (prefix.length() < 12) {
            prefix.append("_");
        }
        return prefix.substring(0, 12);
    }
}

