/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.SparkCopyOpenorgsMergeRels;
import eu.dnetlib.dhp.oa.dedup.SparkCopyRelationsNoOpenorgs;
import eu.dnetlib.dhp.oa.dedup.SparkCreateOrgsDedupRecord;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.dhp.oa.dedup.SparkPropagateRelation;
import eu.dnetlib.dhp.oa.dedup.SparkUpdateEntity;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class SparkOpenorgsProvisionTest
implements Serializable {
    @Mock(serializable=true)
    ISLookUpService isLookUpService;
    private static SparkSession spark;
    private static String testGraphBasePath;
    private static String testOutputBasePath;
    private static String testDedupGraphBasePath;
    private static String testConsistencyGraphBasePath;
    private static final String testActionSetId = "test-orchestrator";

    @BeforeAll
    public static void cleanUp() throws IOException, URISyntaxException {
        testGraphBasePath = Paths.get(SparkOpenorgsProvisionTest.class.getResource("/eu/dnetlib/dhp/dedup/openorgs/provision").toURI()).toFile().getAbsolutePath();
        testOutputBasePath = Files.createTempDirectory(SparkOpenorgsProvisionTest.class.getSimpleName() + "-", new FileAttribute[0]).toAbsolutePath().toString();
        testDedupGraphBasePath = Files.createTempDirectory(SparkOpenorgsProvisionTest.class.getSimpleName() + "-", new FileAttribute[0]).toAbsolutePath().toString();
        testConsistencyGraphBasePath = Files.createTempDirectory(SparkOpenorgsProvisionTest.class.getSimpleName() + "-", new FileAttribute[0]).toAbsolutePath().toString();
        FileUtils.deleteDirectory((File)new File(testOutputBasePath));
        FileUtils.deleteDirectory((File)new File(testDedupGraphBasePath));
        SparkConf conf = new SparkConf();
        conf.set("spark.sql.shuffle.partitions", "200");
        spark = SparkSession.builder().appName(SparkDedupTest.class.getSimpleName()).master("local[*]").config(conf).getOrCreate();
    }

    @AfterAll
    public static void finalCleanUp() throws IOException {
        FileUtils.deleteDirectory((File)new File(testOutputBasePath));
        FileUtils.deleteDirectory((File)new File(testDedupGraphBasePath));
        FileUtils.deleteDirectory((File)new File(testConsistencyGraphBasePath));
    }

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)testActionSetId))).thenReturn((Object)IOUtils.toString((InputStream)SparkDedupTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/profiles/mock_orchestrator_openorgs.xml")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"organization"))).thenReturn((Object)IOUtils.toString((InputStream)SparkDedupTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/org.curr.conf.json")));
    }

    @Test
    @Order(value=1)
    void copyOpenorgsMergeRelTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyOpenorgsMergeRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/copyOpenorgsMergeRels_parameters.json")));
        parser.parseArgument(new String[]{"-i", testGraphBasePath, "-asi", testActionSetId, "-la", "lookupurl", "-w", testOutputBasePath});
        new SparkCopyOpenorgsMergeRels(parser, spark).run(this.isLookUpService);
        long orgs_mergerel = spark.read().load(DedupUtility.createMergeRelPath((String)testOutputBasePath, (String)testActionSetId, (String)"organization")).count();
        Assertions.assertEquals((long)140L, (long)orgs_mergerel);
    }

    @Test
    @Order(value=2)
    void createOrgsDedupRecordTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyOpenorgsMergeRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/copyOpenorgs_parameters.json")));
        parser.parseArgument(new String[]{"-i", testGraphBasePath, "-asi", testActionSetId, "-la", "lookupurl", "-w", testOutputBasePath});
        new SparkCreateOrgsDedupRecord(parser, spark).run(this.isLookUpService);
        long orgs_deduprecord = spark.read().json(DedupUtility.createDedupRecordPath((String)testOutputBasePath, (String)testActionSetId, (String)"organization")).count();
        Assertions.assertEquals((long)10L, (long)orgs_deduprecord);
    }

    @Test
    @Order(value=3)
    void updateEntityTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkUpdateEntity.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/updateEntity_parameters.json")));
        parser.parseArgument(new String[]{"-i", testGraphBasePath, "-w", testOutputBasePath, "-o", testDedupGraphBasePath});
        new SparkUpdateEntity(parser, spark).run(this.isLookUpService);
        Dataset organizations = spark.read().json(testDedupGraphBasePath + "/organization");
        Dataset mergedOrgs = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/organization_mergerel").where("relClass=='merges'").select("target", new String[0]).distinct();
        Assertions.assertEquals((long)80L, (long)organizations.count());
        Dataset deletedOrgs = organizations.filter("dataInfo.deletedbyinference = TRUE");
        Assertions.assertEquals((long)mergedOrgs.count(), (long)deletedOrgs.count());
    }

    @Test
    @Order(value=4)
    void copyRelationsNoOpenorgsTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyRelationsNoOpenorgs.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/updateEntity_parameters.json")));
        parser.parseArgument(new String[]{"-i", testGraphBasePath, "-w", testOutputBasePath, "-o", testDedupGraphBasePath});
        new SparkCopyRelationsNoOpenorgs(parser, spark).run(this.isLookUpService);
        Dataset outputRels = spark.read().text(testDedupGraphBasePath + "/relation");
        Assertions.assertEquals((long)2382L, (long)outputRels.count());
    }

    @Test
    @Order(value=5)
    void propagateRelationsTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkPropagateRelation.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/propagateRelation_parameters.json")));
        parser.parseArgument(new String[]{"-i", testDedupGraphBasePath, "-w", testOutputBasePath, "-o", testConsistencyGraphBasePath});
        new SparkPropagateRelation(parser, spark).run(this.isLookUpService);
        Dataset mergeRels = spark.read().load(DedupUtility.createMergeRelPath((String)testOutputBasePath, (String)"*", (String)"*")).as(Encoders.bean(Relation.class));
        Dataset inputRels = spark.read().json(testDedupGraphBasePath + "/relation");
        Dataset outputRels = spark.read().json(testConsistencyGraphBasePath + "/relation");
        Dataset mergedIds = mergeRels.where("relClass == 'merges'").select(new Column[]{functions.col((String)"target").as("id")}).distinct();
        Dataset toUpdateRels = inputRels.as("rel").join(mergedIds.as("s"), functions.col((String)"rel.source").equalTo((Object)functions.col((String)"s.id")), "left_outer").join(mergedIds.as("t"), functions.col((String)"rel.target").equalTo((Object)functions.col((String)"t.id")), "left_outer").filter("s.id IS NOT NULL OR t.id IS NOT NULL").distinct();
        Dataset updatedRels = inputRels.select("source", new String[]{"target", "relClass"}).except(outputRels.select("source", new String[]{"target", "relClass"}));
        Assertions.assertEquals((long)toUpdateRels.count(), (long)updatedRels.count());
        Assertions.assertEquals((long)140L, (long)outputRels.count());
    }
}

