/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.oa.dedup.IdentifierComparator;
import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.oa.merge.AuthorMerger;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.FlatMapGroupsFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;
import scala.Tuple3;

public class DedupRecordFactory {
    private static final int MAX_ACCEPTANCE_DATE = 20;

    private DedupRecordFactory() {
    }

    public static Dataset<OafEntity> createDedupRecord(SparkSession spark, DataInfo dataInfo, String mergeRelsInputPath, String entitiesInputPath, Class<OafEntity> clazz) {
        long ts = System.currentTimeMillis();
        Encoder beanEncoder = Encoders.bean(clazz);
        Encoder kryoEncoder = Encoders.kryo(clazz);
        Dataset entities = spark.read().schema(Encoders.bean(clazz).schema()).json(entitiesInputPath).as(beanEncoder).map((MapFunction & Serializable)entity -> new Tuple2((Object)entity.getId(), entity), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)kryoEncoder)).selectExpr(new String[]{"_1 AS id", "_2 AS kryoObject"});
        Dataset mergeRels = spark.read().load(mergeRelsInputPath).where("relClass == 'merges'").selectExpr(new String[]{"source as dedupId", "target as id"});
        return mergeRels.join(entities, DHPUtils.toSeq(Collections.singletonList("id")).toSeq(), "left").selectExpr(new String[]{"dedupId", "id", "coalesce(kryoObject, X'00') AS kryoObject"}).as(Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING(), (Encoder)kryoEncoder)).groupByKey(Tuple3::_1, Encoders.STRING()).flatMapGroups((FlatMapGroupsFunction & Serializable)(dedupId, it) -> {
            if (!it.hasNext()) {
                return Collections.emptyIterator();
            }
            ArrayList<OafEntity> cliques = new ArrayList<OafEntity>();
            ArrayList<String> aliases = new ArrayList<String>();
            HashSet<String> acceptanceDate = new HashSet<String>();
            boolean isVisible = false;
            while (it.hasNext()) {
                Result result;
                Tuple3 t = (Tuple3)it.next();
                OafEntity entity = (OafEntity)t._3();
                if (entity == null) {
                    aliases.add((String)t._2());
                    continue;
                }
                isVisible = isVisible || entity.getDataInfo().getInvisible() == false;
                cliques.add(entity);
                if (acceptanceDate.size() >= 20 || !Publication.class.isAssignableFrom(entity.getClass()) || (result = (Result)entity).getDateofacceptance() == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)result.getDateofacceptance().getValue()))) continue;
                acceptanceDate.add((String)result.getDateofacceptance().getValue());
            }
            if (!isVisible || acceptanceDate.size() >= 20 || cliques.isEmpty()) {
                return Collections.emptyIterator();
            }
            OafEntity mergedEntity = (OafEntity)MergeUtils.mergeGroup(cliques.iterator());
            mergedEntity.setDateoftransformation(null);
            mergedEntity.setMergedIds(Stream.concat(cliques.stream().map(OafEntity::getId), aliases.stream()).distinct().sorted().collect(Collectors.toList()));
            return Stream.concat(Stream.of(dedupId).map(id -> DedupRecordFactory.createDedupOafEntity(id, mergedEntity, dataInfo, ts)), aliases.stream().map(id -> DedupRecordFactory.createMergedDedupAliasOafEntity(id, mergedEntity, dataInfo, ts))).iterator();
        }, beanEncoder);
    }

    private static OafEntity createDedupOafEntity(String id, OafEntity base, DataInfo dataInfo, long ts) {
        try {
            OafEntity res = (OafEntity)BeanUtils.cloneBean((Object)base);
            res.setId(id);
            res.setDataInfo(dataInfo);
            res.setLastupdatetimestamp(Long.valueOf(ts));
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static OafEntity createMergedDedupAliasOafEntity(String id, OafEntity base, DataInfo dataInfo, long ts) {
        try {
            OafEntity res = DedupRecordFactory.createDedupOafEntity(id, base, dataInfo, ts);
            DataInfo ds = (DataInfo)BeanUtils.cloneBean((Object)dataInfo);
            ds.setDeletedbyinference(Boolean.valueOf(true));
            res.setDataInfo(ds);
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static OafEntity reduceEntity(OafEntity entity, OafEntity duplicate) {
        if (duplicate == null) {
            return entity;
        }
        int compare = new IdentifierComparator<OafEntity>().compare(Identifier.newInstance(entity), Identifier.newInstance(duplicate));
        if (compare > 0) {
            OafEntity swap = duplicate;
            duplicate = entity;
            entity = swap;
        }
        entity = (OafEntity)MergeUtils.checkedMerge((Oaf)entity, (Oaf)duplicate, (boolean)false);
        if (ModelSupport.isSubClass((Oaf)duplicate, Result.class).booleanValue()) {
            Result re = (Result)entity;
            Result rd = (Result)duplicate;
            ArrayList<List> authors = new ArrayList<List>();
            if (re.getAuthor() != null) {
                authors.add(re.getAuthor());
            }
            if (rd.getAuthor() != null) {
                authors.add(rd.getAuthor());
            }
            re.setAuthor(AuthorMerger.merge(authors));
        }
        return entity;
    }

    public static <T extends OafEntity> T entityMerger(String id, Iterator<Tuple2<String, T>> entities, long ts, DataInfo dataInfo, Class<T> clazz) {
        OafEntity base = (OafEntity)entities.next()._2();
        while (entities.hasNext()) {
            OafEntity duplicate = (OafEntity)entities.next()._2();
            if (duplicate == null) continue;
            base = DedupRecordFactory.reduceEntity(base, duplicate);
        }
        base.setId(id);
        base.setDataInfo(dataInfo);
        base.setLastupdatetimestamp(Long.valueOf(ts));
        return (T)base;
    }

    public static final class DedupRecordReduceState {
        public final String dedupId;
        public final ArrayList<String> aliases = new ArrayList();
        public final HashSet<String> acceptanceDate = new HashSet();
        public OafEntity entity;

        public DedupRecordReduceState(String dedupId, String id, OafEntity entity) {
            Result result;
            this.dedupId = dedupId;
            this.entity = entity;
            if (entity == null) {
                this.aliases.add(id);
            } else if (Result.class.isAssignableFrom(entity.getClass()) && (result = (Result)entity).getDateofacceptance() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)result.getDateofacceptance().getValue()))) {
                this.acceptanceDate.add((String)result.getDateofacceptance().getValue());
            }
        }

        public String getDedupId() {
            return this.dedupId;
        }
    }
}

