/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.SparkCreateDedupRecord;
import eu.dnetlib.dhp.oa.dedup.SparkCreateMergeRels;
import eu.dnetlib.dhp.oa.dedup.SparkCreateSimRels;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class SparkPublicationRootsTest2
implements Serializable {
    @Mock(serializable=true)
    ISLookUpService isLookUpService;
    private static SparkSession spark;
    private static String workingPath;
    private static String graphInputPath;
    private static String graphOutputPath;
    private static final String testActionSetId = "test-orchestrator";
    private static Path testBaseTmpPath;
    private static final ObjectMapper MAPPER;

    @BeforeAll
    public static void init() throws IOException, URISyntaxException {
        testBaseTmpPath = Files.createTempDirectory(SparkPublicationRootsTest2.class.getSimpleName() + "-", new FileAttribute[0]);
        File entitiesSources = Paths.get(SparkPublicationRootsTest2.class.getResource("/eu/dnetlib/dhp/dedup/root").toURI()).toFile();
        FileUtils.copyDirectory((File)entitiesSources, (File)testBaseTmpPath.resolve("input").toFile());
        FileUtils.copyFileToDirectory((File)Paths.get(SparkPublicationRootsTest2.class.getResource("/eu/dnetlib/dhp/dedup/root/alterations/publication/publication_1.gz").toURI()).toFile(), (File)testBaseTmpPath.resolve("input").resolve("entities").resolve("publication").toFile());
        workingPath = testBaseTmpPath.resolve("workingPath").toString();
        graphInputPath = testBaseTmpPath.resolve("input").resolve("entities").toString();
        graphOutputPath = testBaseTmpPath.resolve("output").toString();
        SparkConf conf = new SparkConf();
        conf.set("spark.sql.shuffle.partitions", "10");
        spark = SparkSession.builder().appName(SparkPublicationRootsTest2.class.getSimpleName()).master("local[*]").config(conf).getOrCreate();
    }

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)testActionSetId))).thenReturn((Object)SparkPublicationRootsTest2.classPathResourceAsString("/eu/dnetlib/dhp/dedup/profiles/mock_orchestrator_publication.xml"));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"publication"))).thenReturn((Object)SparkPublicationRootsTest2.classPathResourceAsString("/eu/dnetlib/dhp/dedup/conf/pub.curr.conf.json"));
    }

    @AfterAll
    public static void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)testBaseTmpPath.toFile());
    }

    @Test
    @Order(value=7)
    void dedupAlteredDatasetTest() throws Exception {
        new SparkCreateSimRels(this.args("/eu/dnetlib/dhp/oa/dedup/createSimRels_parameters.json", new String[]{"--graphBasePath", graphInputPath, "--actionSetId", testActionSetId, "--isLookUpUrl", "lookupurl", "--workingPath", workingPath, "--numPartitions", "5"}), spark).run(this.isLookUpService);
        new SparkCreateMergeRels(this.args("/eu/dnetlib/dhp/oa/dedup/createCC_parameters.json", new String[]{"--graphBasePath", graphInputPath, "--actionSetId", testActionSetId, "--isLookUpUrl", "lookupurl", "--workingPath", workingPath, "--hiveMetastoreUris", ""}), spark).run(this.isLookUpService);
        Dataset merges = spark.read().load(workingPath + "/test-orchestrator/publication_mergerel").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)4L, (long)merges.filter("relclass == 'isMergedIn'").map(Relation::getTarget, Encoders.STRING()).distinct().count());
        Assertions.assertEquals((long)4L, (long)merges.filter("source == '50|doi_dedup___::b3aec7985136e36827176aaa1dd5082d'").count());
        new SparkCreateDedupRecord(this.args("/eu/dnetlib/dhp/oa/dedup/createDedupRecord_parameters.json", new String[]{"--graphBasePath", graphInputPath, "--actionSetId", testActionSetId, "--isLookUpUrl", "lookupurl", "--workingPath", workingPath}), spark).run(this.isLookUpService);
        Dataset roots = spark.read().textFile(workingPath + "/test-orchestrator/publication_deduprecord").map(SparkPublicationRootsTest2.asEntity(Publication.class), Encoders.bean(Publication.class));
        Assertions.assertEquals((long)4L, (long)roots.count());
        Dataset pubs = spark.read().textFile(DedupUtility.createEntityPath((String)graphInputPath, (String)"publication")).map(SparkPublicationRootsTest2.asEntity(Publication.class), Encoders.bean(Publication.class));
        Publication root = (Publication)roots.filter("id = '50|doi_dedup___::b3aec7985136e36827176aaa1dd5082d'").first();
        Assertions.assertNotNull((Object)root);
        Publication crossref_duplicate = (Publication)pubs.filter("id = '50|doi_________::b3aec7985136e36827176aaa1dd5082d'").collectAsList().get(0);
        Assertions.assertEquals((Object)crossref_duplicate.getJournal().getName(), (Object)root.getJournal().getName());
        Assertions.assertEquals((Object)crossref_duplicate.getJournal().getIssnPrinted(), (Object)root.getJournal().getIssnPrinted());
        Assertions.assertEquals((Object)crossref_duplicate.getPublisher().getValue(), (Object)root.getPublisher().getValue());
        Set rootPids = root.getPid().stream().map(StructuredProperty::getValue).collect(Collectors.toCollection(HashSet::new));
        Set dupPids = crossref_duplicate.getPid().stream().map(StructuredProperty::getValue).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertFalse((boolean)Sets.intersection((Set)rootPids, (Set)dupPids).isEmpty());
        Assertions.assertTrue((boolean)rootPids.contains("10.1109/jstqe.2022.3205716"));
        Assertions.assertTrue((boolean)rootPids.contains("10.1109/jstqe.2023.9999999"));
        Optional<Instance> instance_cr = root.getInstance().stream().filter(i -> i.getCollectedfrom().getValue().equals("Crossref")).findFirst();
        Assertions.assertTrue((boolean)instance_cr.isPresent());
        Assertions.assertEquals((Object)"OPEN", (Object)instance_cr.get().getAccessright().getClassid());
        Assertions.assertEquals((Object)"Open Access", (Object)instance_cr.get().getAccessright().getClassname());
        Assertions.assertEquals((Object)OpenAccessRoute.hybrid, (Object)instance_cr.get().getAccessright().getOpenAccessRoute());
        Assertions.assertEquals((Object)"IEEE Journal of Selected Topics in Quantum Electronics", (Object)instance_cr.get().getHostedby().getValue());
        Assertions.assertEquals((Object)"0001", (Object)instance_cr.get().getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Article", (Object)instance_cr.get().getInstancetype().getClassname());
    }

    private static String classPathResourceAsString(String path) throws IOException {
        return IOUtils.toString((InputStream)SparkPublicationRootsTest2.class.getResourceAsStream(path));
    }

    private static <T extends OafEntity> MapFunction<String, T> asEntity(Class<T> clazz) {
        return (MapFunction & Serializable)value -> (OafEntity)MAPPER.readValue(value, clazz);
    }

    private ArgumentApplicationParser args(String paramSpecs, String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(SparkPublicationRootsTest2.classPathResourceAsString(paramSpecs));
        parser.parseArgument(args);
        return parser;
    }

    static {
        MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

