/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup.sx;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.scholexplorer.DLIDataset;
import eu.dnetlib.dhp.schema.scholexplorer.DLIPublication;
import eu.dnetlib.dhp.schema.scholexplorer.DLIUnknown;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkUpdateEntityJob {
    static final String IDJSONPATH = "$.id";

    public static void main(String[] args) throws Exception {
        Class<DLIPublication> mainClass;
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkUpdateEntityJob.class.getResourceAsStream("/eu/dnetlib/dhp/sx/dedup/dedup_delete_by_inference_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkUpdateEntityJob.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String entityPath = parser.get("entityPath");
        String mergeRelPath = parser.get("mergeRelPath");
        String dedupRecordPath = parser.get("dedupRecordPath");
        String entity = parser.get("entity");
        String destination = parser.get("targetPath");
        Dataset df = spark.read().load(mergeRelPath).as(Encoders.bean(Relation.class));
        JavaPairRDD mergedIds = df.where("relClass == 'merges'").select(new Column[]{df.col("target")}).distinct().toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getString(0), (Object)"d"));
        JavaRDD sourceEntity = sc.textFile(entityPath);
        JavaRDD dedupEntity = sc.textFile(dedupRecordPath);
        JavaPairRDD entitiesWithId = sourceEntity.mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)DHPUtils.getJPathString((String)IDJSONPATH, (String)s), s));
        switch (entity) {
            case "publication": {
                mainClass = DLIPublication.class;
                break;
            }
            case "dataset": {
                mainClass = DLIDataset.class;
                break;
            }
            case "unknown": {
                mainClass = DLIUnknown.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type " + entity);
            }
        }
        JavaRDD map = entitiesWithId.leftOuterJoin(mergedIds).map((Function & Serializable)k -> ((Optional)((Tuple2)k._2())._2()).isPresent() ? SparkUpdateEntityJob.updateDeletedByInference((String)((Tuple2)k._2())._1(), mainClass) : (String)((Tuple2)k._2())._1());
        map.union(dedupEntity).saveAsTextFile(destination, GzipCodec.class);
    }

    private static <T extends Oaf> String updateDeletedByInference(String json, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Oaf entity = (Oaf)mapper.readValue(json, clazz);
            if (entity.getDataInfo() == null) {
                entity.setDataInfo(new DataInfo());
            }
            entity.getDataInfo().setDeletedbyinference(Boolean.valueOf(true));
            return mapper.writeValueAsString((Object)entity);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert json", e);
        }
    }
}

