/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dedup.DedupUtility;
import eu.dnetlib.pace.util.PaceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ConnectedComponent
implements Serializable {
    private Set<String> docIds;
    private String ccId;

    public ConnectedComponent() {
    }

    public ConnectedComponent(Set<String> docIds) {
        this.docIds = docIds;
        this.createID();
    }

    public String createID() {
        if (this.docIds.size() > 1) {
            String s = this.getMin();
            String prefix = s.split("\\|")[0];
            this.ccId = prefix + "|dedup_wf_001::" + DedupUtility.md5(s);
            return this.ccId;
        }
        return this.docIds.iterator().next();
    }

    @JsonIgnore
    public String getMin() {
        StringBuilder min = new StringBuilder();
        this.docIds.forEach(i -> {
            if (StringUtils.isBlank((String)min.toString())) {
                min.append((String)i);
            } else if (min.toString().compareTo((String)i) > 0) {
                min.setLength(0);
                min.append((String)i);
            }
        });
        return min.toString();
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("Failed to create Json: ", (Throwable)e);
        }
    }

    public Set<String> getDocIds() {
        return this.docIds;
    }

    public void setDocIds(Set<String> docIds) {
        this.docIds = docIds;
    }

    public String getCcId() {
        return this.ccId;
    }

    public void setCcId(String ccId) {
        this.ccId = ccId;
    }
}

