/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dedup.sx;

import eu.dnetlib.dedup.sx.SparkUpdateEntityJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.scholexplorer.OafUtils;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;

public class SparkPropagateRelationsJob {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkPropagateRelationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/sx/dedup/dedup_propagate_relation_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkUpdateEntityJob.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        String relationPath = parser.get("relationPath");
        String mergeRelPath = parser.get("mergeRelPath");
        String targetRelPath = parser.get("targetRelPath");
        Dataset merge = spark.read().load(mergeRelPath).as(Encoders.bean(Relation.class)).where("relClass == 'merges'");
        Dataset rels = spark.read().load(relationPath).as(Encoders.kryo(Relation.class)).map((MapFunction & Serializable)r -> r, Encoders.bean(Relation.class));
        Dataset firstJoin = rels.joinWith(merge, merge.col("target").equalTo((Object)rels.col("source")), "left_outer").map((MapFunction & Serializable)r -> {
            Relation mergeRelation = (Relation)r._2();
            Relation relation = (Relation)r._1();
            if (mergeRelation != null) {
                relation.setSource(mergeRelation.getSource());
            }
            if (relation.getDataInfo() == null) {
                relation.setDataInfo(OafUtils.generateDataInfo((String)"0.9", (boolean)false));
            }
            return relation;
        }, Encoders.bean(Relation.class));
        Dataset secondJoin = firstJoin.joinWith(merge, merge.col("target").equalTo((Object)firstJoin.col("target")), "left_outer").map((MapFunction & Serializable)r -> {
            Relation mergeRelation = (Relation)r._2();
            Relation relation = (Relation)r._1();
            if (mergeRelation != null) {
                relation.setTarget(mergeRelation.getSource());
            }
            return relation;
        }, Encoders.kryo(Relation.class));
        secondJoin.write().mode(SaveMode.Overwrite).save(targetRelPath);
    }
}

