/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost;

import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.doiboost.HostedByItemType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class DoiBoostMappingUtil$ {
    public static final DoiBoostMappingUtil$ MODULE$;
    private final Logger logger;
    private final String MAG;
    private final String MAG_NAME;
    private final String ORCID;
    private final String CROSSREF;
    private final String UNPAYWALL;
    private final String GRID_AC;
    private final String WIKPEDIA;
    private final String doiBoostNSPREFIX;
    private final String OPENAIRE_PREFIX;
    private final String SEPARATOR;
    private final String DNET_LANGUAGES;
    private final String PID_TYPES;
    private final List<String> invalidName;

    static {
        new DoiBoostMappingUtil$();
    }

    public Qualifier getUnknownCountry() {
        return this.createQualifier("UNKNOWN", "UNKNOWN", "dnet:countries", "dnet:countries");
    }

    public String generateMAGAffiliationId(String affId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"20|microsoft___", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SEPARATOR(), DHPUtils.md5((String)affId)}));
    }

    public Logger logger() {
        return this.logger;
    }

    public String MAG() {
        return this.MAG;
    }

    public String MAG_NAME() {
        return this.MAG_NAME;
    }

    public String ORCID() {
        return this.ORCID;
    }

    public String CROSSREF() {
        return this.CROSSREF;
    }

    public String UNPAYWALL() {
        return this.UNPAYWALL;
    }

    public String GRID_AC() {
        return this.GRID_AC;
    }

    public String WIKPEDIA() {
        return this.WIKPEDIA;
    }

    public String doiBoostNSPREFIX() {
        return this.doiBoostNSPREFIX;
    }

    public String OPENAIRE_PREFIX() {
        return this.OPENAIRE_PREFIX;
    }

    public String SEPARATOR() {
        return this.SEPARATOR;
    }

    public String DNET_LANGUAGES() {
        return this.DNET_LANGUAGES;
    }

    public String PID_TYPES() {
        return this.PID_TYPES;
    }

    public List<String> invalidName() {
        return this.invalidName;
    }

    public Tuple2<String, String> toActionSet(Oaf item) {
        Tuple2 tuple2;
        ObjectMapper mapper = new ObjectMapper();
        Oaf oaf = item;
        if (oaf instanceof Dataset) {
            Dataset dataset = (Dataset)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Dataset.class);
            a.setPayload((Oaf)dataset);
            tuple2 = new Tuple2((Object)dataset.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Publication) {
            Publication publication = (Publication)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Publication.class);
            a.setPayload((Oaf)publication);
            tuple2 = new Tuple2((Object)publication.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Organization) {
            Organization organization = (Organization)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Organization.class);
            a.setPayload((Oaf)organization);
            tuple2 = new Tuple2((Object)organization.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Relation) {
            Relation relation = (Relation)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Relation.class);
            a.setPayload((Oaf)relation);
            tuple2 = new Tuple2((Object)relation.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else {
            tuple2 = null;
        }
        return tuple2;
    }

    public Tuple2<String, HostedByItemType> toHostedByItem(String input) {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Map c = (Map)package$.MODULE$.jvalue2extractable(this.json$1(input, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(HostedByItemType.class)})));
        return new Tuple2(c.keys().head(), c.values().head());
    }

    public Tuple2<String, Publication> toISSNPair(Publication publication) {
        String lissn;
        String issn = publication.getJournal() == null ? null : publication.getJournal().getIssnPrinted();
        String eissn = publication.getJournal() == null ? null : publication.getJournal().getIssnOnline();
        String string = lissn = publication.getJournal() == null ? null : publication.getJournal().getIssnLinking();
        return issn != null && new StringOps(Predef$.MODULE$.augmentString(issn)).nonEmpty() ? new Tuple2((Object)issn, (Object)publication) : (eissn != null && new StringOps(Predef$.MODULE$.augmentString(eissn)).nonEmpty() ? new Tuple2((Object)eissn, (Object)publication) : (lissn != null && new StringOps(Predef$.MODULE$.augmentString(lissn)).nonEmpty() ? new Tuple2((Object)lissn, (Object)publication) : new Tuple2((Object)publication.getId(), (Object)publication)));
    }

    public String generateGridAffiliationId(String gridId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"20|grid________::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)gridId.toLowerCase().trim())}));
    }

    public Dataset fixResult(Dataset result) {
        Option instanceType = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getInstancetype() != null && new StringOps(Predef$.MODULE$.augmentString(i.getInstancetype().getClassid())).nonEmpty();
            }
        });
        if (instanceType.isDefined()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).foreach((Function1)new Serializable(instanceType){
                public static final long serialVersionUID = 0L;
                private final Option instanceType$1;

                public final void apply(Instance i) {
                    i.setInstancetype(((Instance)this.instanceType$1.get()).getInstancetype());
                }
                {
                    this.instanceType$1 = instanceType$1;
                }
            });
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Instance i) {
                i.setHostedby(DoiBoostMappingUtil$.MODULE$.getUbknownHostedBy());
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue getUbknownHostedBy() {
        void var1_1;
        KeyValue hb = new KeyValue();
        hb.setValue("Unknown Repository");
        hb.setKey(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10|", "::55045bd2a65019fd8e6741a755395c8c"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.OPENAIRE_PREFIX()})));
        return var1_1;
    }

    public Qualifier getOpenAccessQualifier() {
        return this.createQualifier("OPEN", "Open Access", "dnet:access_modes", "dnet:access_modes");
    }

    public Qualifier getRestrictedQualifier() {
        return this.createQualifier("RESTRICTED", "Restricted", "dnet:access_modes", "dnet:access_modes");
    }

    /*
     * WARNING - void declaration
     */
    public Publication fixPublication(Tuple2<Tuple2<String, Publication>, Tuple2<String, HostedByItemType>> input) {
        void var2_2;
        Publication publication = (Publication)((Tuple2)input._1())._2();
        HostedByItemType item = input._2() == null ? null : (HostedByItemType)((Tuple2)input._2())._2();
        Option instanceType = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getInstance()).asScala()).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getInstancetype() != null && new StringOps(Predef$.MODULE$.augmentString(i.getInstancetype().getClassid())).nonEmpty();
            }
        });
        if (instanceType.isDefined()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getInstance()).asScala()).foreach((Function1)new Serializable(instanceType){
                public static final long serialVersionUID = 0L;
                private final Option instanceType$2;

                public final void apply(Instance i) {
                    i.setInstancetype(((Instance)this.instanceType$2.get()).getInstancetype());
                }
                {
                    this.instanceType$2 = instanceType$2;
                }
            });
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getInstance()).asScala()).foreach((Function1)new Serializable(publication, item){
            public static final long serialVersionUID = 0L;
            private final Publication publication$1;
            private final HostedByItemType item$1;

            public final void apply(Instance i) {
                KeyValue hb = new KeyValue();
                if (this.item$1 == null) {
                    hb.setValue("Unknown Repository");
                    hb.setKey(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10|", "::55045bd2a65019fd8e6741a755395c8c"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DoiBoostMappingUtil$.MODULE$.OPENAIRE_PREFIX()})));
                } else {
                    hb.setValue(this.item$1.officialname());
                    hb.setKey(DoiBoostMappingUtil$.MODULE$.generateDSId(this.item$1.id()));
                    if (this.item$1.openAccess()) {
                        i.setAccessright(DoiBoostMappingUtil$.MODULE$.getOpenAccessQualifier());
                    }
                    this.publication$1.setBestaccessright(DoiBoostMappingUtil$.MODULE$.getOpenAccessQualifier());
                }
                i.setHostedby(hb);
            }
            {
                this.publication$1 = publication$1;
                this.item$1 = item$1;
            }
        });
        Buffer ar = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getInstancetype() != null && i.getAccessright() != null && i.getAccessright().getClassid() != null;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Instance f) {
                return f.getAccessright().getClassid();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (ar.nonEmpty()) {
            if (ar.contains((Object)"OPEN")) {
                publication.setBestaccessright(this.getOpenAccessQualifier());
            } else {
                publication.setBestaccessright(this.getRestrictedQualifier());
            }
        }
        return var2_2;
    }

    public String generateDSId(String input) {
        String b = StringUtils.substringBefore((String)input, (String)"::");
        String a = StringUtils.substringAfter((String)input, (String)"::");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10|", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{b, DHPUtils.md5((String)a)}));
    }

    public DataInfo generateDataInfo() {
        return this.generateDataInfo("0.9");
    }

    public boolean filterPublication(Publication publication) {
        String publisher;
        if (publication == null) {
            return false;
        }
        if (publication.getTitle() == null || publication.getTitle().size() == 0) {
            return false;
        }
        int s = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getTitle()).asScala()).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty p) {
                return p.getValue() != null && new StringOps(Predef$.MODULE$.augmentString(p.getValue())).nonEmpty() && !p.getValue().equalsIgnoreCase("[NO TITLE AVAILABLE]");
            }
        });
        if (s == 0) {
            return false;
        }
        String string = publisher = publication.getPublisher() == null ? null : (String)publication.getPublisher().getValue();
        if (publisher != null && (publisher.equalsIgnoreCase("Test accounts") || publisher.equalsIgnoreCase("CrossRef Test Account"))) {
            return false;
        }
        if (publication.getAuthor() == null || publication.getAuthor().size() == 0) {
            return false;
        }
        Buffer authors = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getAuthor()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Author s) {
                return new StringOps(Predef$.MODULE$.augmentString(s.getFullname())).nonEmpty() ? s.getFullname() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getName(), s.getSurname()}));
            }
        }, Buffer$.MODULE$.canBuildFrom());
        int c = authors.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String fullName) {
                return DoiBoostMappingUtil$.MODULE$.isValidAuthorName(fullName);
            }
        });
        if (c == 0) {
            return false;
        }
        return authors.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return s.equalsIgnoreCase("Addie Jackson");
            }
        }) <= 0 || !"Elsevier BV".equalsIgnoreCase((String)publication.getPublisher().getValue());
    }

    public boolean isValidAuthorName(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return false;
        }
        return !this.invalidName().contains((Object)fullName.toLowerCase().trim());
    }

    /*
     * WARNING - void declaration
     */
    public DataInfo generateDataInfo(String trust) {
        void var2_2;
        DataInfo di = new DataInfo();
        di.setDeletedbyinference(Predef$.MODULE$.boolean2Boolean(false));
        di.setInferred(Predef$.MODULE$.boolean2Boolean(false));
        di.setInvisible(Predef$.MODULE$.boolean2Boolean(false));
        di.setTrust(trust);
        di.setProvenanceaction(this.createQualifier("sysimport:actionset", "dnet:provenanceActions"));
        return var2_2;
    }

    public StructuredProperty createSP(String value, String classId, String schemeId) {
        StructuredProperty sp = new StructuredProperty();
        sp.setQualifier(this.createQualifier(classId, schemeId));
        sp.setValue(value);
        return sp;
    }

    public StructuredProperty createSP(String value, String classId, String schemeId, DataInfo dataInfo) {
        StructuredProperty sp = new StructuredProperty();
        sp.setQualifier(this.createQualifier(classId, schemeId));
        sp.setValue(value);
        sp.setDataInfo(dataInfo);
        return sp;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createCrossrefCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue(this.CROSSREF());
        cf.setKey(new StringBuilder().append((Object)"10|").append((Object)this.OPENAIRE_PREFIX()).append((Object)this.SEPARATOR()).append((Object)DHPUtils.md5((String)this.CROSSREF().toLowerCase())).toString());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createUnpayWallCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue(this.UNPAYWALL());
        cf.setKey(new StringBuilder().append((Object)"10|").append((Object)this.OPENAIRE_PREFIX()).append((Object)this.SEPARATOR()).append((Object)DHPUtils.md5((String)this.UNPAYWALL().toLowerCase())).toString());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createORIDCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue(this.ORCID());
        cf.setKey(new StringBuilder().append((Object)"10|").append((Object)this.OPENAIRE_PREFIX()).append((Object)this.SEPARATOR()).append((Object)DHPUtils.md5((String)this.ORCID().toLowerCase())).toString());
        return var1_1;
    }

    public String generateIdentifier(Result oaf, String doi) {
        String id = DHPUtils.md5((String)doi.toLowerCase());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"50|", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.doiBoostNSPREFIX(), this.SEPARATOR(), id}));
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createMAGCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue(this.MAG_NAME());
        cf.setKey(new StringBuilder().append((Object)"10|").append((Object)this.OPENAIRE_PREFIX()).append((Object)this.SEPARATOR()).append((Object)DHPUtils.md5((String)this.MAG())).toString());
        return var1_1;
    }

    public Qualifier createQualifier(String clsName, String clsValue, String schName, String schValue) {
        Qualifier q = new Qualifier();
        q.setClassid(clsName);
        q.setClassname(clsValue);
        q.setSchemeid(schName);
        q.setSchemename(schValue);
        return q;
    }

    public Qualifier createQualifier(String cls, String sch) {
        return this.createQualifier(cls, cls, sch, sch);
    }

    /*
     * WARNING - void declaration
     */
    public <T> Field<T> asField(T value) {
        void var2_2;
        Field tmp = new Field();
        tmp.setValue(value);
        return var2_2;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        DoiBoostMappingUtil$ doiBoostMappingUtil$ = this;
        synchronized (doiBoostMappingUtil$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        DoiBoostMappingUtil$ doiBoostMappingUtil$ = this;
        synchronized (doiBoostMappingUtil$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private DoiBoostMappingUtil$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.MAG = "microsoft";
        this.MAG_NAME = "Microsoft Academic Graph";
        this.ORCID = "ORCID";
        this.CROSSREF = "Crossref";
        this.UNPAYWALL = "UnpayWall";
        this.GRID_AC = "grid.ac";
        this.WIKPEDIA = "wikpedia";
        this.doiBoostNSPREFIX = "doiboost____";
        this.OPENAIRE_PREFIX = "openaire____";
        this.SEPARATOR = "::";
        this.DNET_LANGUAGES = "dnet:languages";
        this.PID_TYPES = "dnet:pid_types";
        this.invalidName = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", "none none", "none, none", "none &na;", "(:null)", "test test test", "test test", "test", "&na; &na;"}));
    }
}

