/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.orcid.ActivitiesDecompressor;
import eu.dnetlib.doiboost.orcid.OrcidDSManager;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.mortbay.log.Log;

public class OrcidAuthorsDOIsDataGen
extends OrcidDSManager {
    private String activitiesFileNameTarGz;
    private String outputAuthorsDOIsPath;

    public static void main(String[] args) throws IOException, Exception {
        OrcidAuthorsDOIsDataGen orcidAuthorsDOIsDataGen = new OrcidAuthorsDOIsDataGen();
        orcidAuthorsDOIsDataGen.loadArgs(args);
        orcidAuthorsDOIsDataGen.generateAuthorsDOIsData();
    }

    public void generateAuthorsDOIsData() throws Exception {
        Configuration conf = this.initConfigurationObject();
        FileSystem fs = this.initFileSystemObject(conf);
        String tarGzUri = this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.activitiesFileNameTarGz);
        Path outputPath = new Path(this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.outputAuthorsDOIsPath));
        ActivitiesDecompressor.parseGzActivities(conf, tarGzUri, outputPath);
    }

    private void loadArgs(String[] args) throws IOException, Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)OrcidAuthorsDOIsDataGen.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/create_orcid_authors_dois_data.json")));
        parser.parseArgument(args);
        this.hdfsServerUri = parser.get("hdfsServerUri");
        Log.info((String)("HDFS URI: " + this.hdfsServerUri));
        this.hdfsOrcidDefaultPath = parser.get("hdfsOrcidDefaultPath");
        Log.info((String)("Default Path: " + this.hdfsOrcidDefaultPath));
        this.activitiesFileNameTarGz = parser.get("activitiesFileNameTarGz");
        Log.info((String)("Activities File Name: " + this.activitiesFileNameTarGz));
        this.outputAuthorsDOIsPath = parser.get("outputAuthorsDOIsPath");
        Log.info((String)("Output Authors DOIs Data: " + this.outputAuthorsDOIsPath));
    }
}

