/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.crossref;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESClient
implements Iterator<String> {
    private static final Logger logger = LoggerFactory.getLogger(ESClient.class);
    static final String blobPath = "$.hits[*].hits[*]._source.blob";
    static final String scrollIdPath = "$._scroll_id";
    static final String JSON_NO_TS = "{\"size\":1000}";
    static final String JSON_WITH_TS = "{\"size\":1000, \"query\":{\"range\":{\"timestamp\":{\"gte\":%d}}}}";
    static final String JSON_SCROLL = "{\"scroll_id\":\"%s\",\"scroll\" : \"1m\"}";
    private final String scrollId;
    private List<String> buffer;
    private final String esHost;

    public ESClient(String esHost, String esIndex) throws IOException {
        this.esHost = esHost;
        String body = this.getResponse(String.format("http://%s:9200/%s/_search?scroll=1m", esHost, esIndex), JSON_NO_TS);
        this.scrollId = this.getJPathString(scrollIdPath, body);
        this.buffer = this.getBlobs(body);
    }

    public ESClient(String esHost, String esIndex, long timestamp) throws IOException {
        this.esHost = esHost;
        String body = this.getResponse(String.format("http://%s:9200/%s/_search?scroll=1m", esHost, esIndex), String.format(JSON_WITH_TS, timestamp));
        this.scrollId = this.getJPathString(scrollIdPath, body);
        this.buffer = this.getBlobs(body);
    }

    private String getResponse(String url, String json) {
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (json != null) {
                StringEntity entity = new StringEntity(json);
                httpPost.setEntity((HttpEntity)entity);
                httpPost.setHeader("Accept", "application/json");
                httpPost.setHeader("Content-type", "application/json");
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error on executing request ", e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close client ", e);
            }
        }
    }

    private String getJPathString(String jsonPath, String json) {
        try {
            Object o = JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception e) {
            return "";
        }
    }

    private List<String> getBlobs(String body) {
        List res = (List)JsonPath.read((String)body, (String)"$.hits.hits[*]._source.blob", (Predicate[])new Predicate[0]);
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null && !this.buffer.isEmpty();
    }

    @Override
    public String next() {
        String nextItem = this.buffer.remove(0);
        if (this.buffer.isEmpty()) {
            String json_param = String.format(JSON_SCROLL, this.scrollId);
            String body = this.getResponse(String.format("http://%s:9200/_search/scroll", this.esHost), json_param);
            try {
                this.buffer = this.getBlobs(body);
            }
            catch (Throwable e) {
                logger.error("Error on  get next page: body:" + body);
            }
        }
        return nextItem;
    }
}

