/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.orcid.SummariesDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.mortbay.log.Log;

public class OrcidDSManager {
    protected String hdfsServerUri;
    protected String hdfsOrcidDefaultPath;
    private String summariesFileNameTarGz;
    private String outputAuthorsPath;

    public static void main(String[] args) throws IOException, Exception {
        OrcidDSManager orcidDSManager = new OrcidDSManager();
        orcidDSManager.loadArgs(args);
        orcidDSManager.generateAuthors();
    }

    public void generateAuthors() throws Exception {
        Configuration conf = this.initConfigurationObject();
        FileSystem fs = this.initFileSystemObject(conf);
        String tarGzUri = this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.summariesFileNameTarGz);
        Path outputPath = new Path(this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.outputAuthorsPath).concat("authors.seq"));
        SummariesDecompressor.parseGzSummaries(conf, tarGzUri, outputPath);
    }

    protected Configuration initConfigurationObject() {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath));
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        return conf;
    }

    protected FileSystem initFileSystemObject(Configuration conf) {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((URI)URI.create(this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath)), (Configuration)conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fs;
    }

    private void loadArgs(String[] args) throws IOException, Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)OrcidDSManager.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/create_orcid_authors_data.json")));
        parser.parseArgument(args);
        this.hdfsServerUri = parser.get("hdfsServerUri");
        Log.info((String)("HDFS URI: " + this.hdfsServerUri));
        this.hdfsOrcidDefaultPath = parser.get("hdfsOrcidDefaultPath");
        Log.info((String)("Default Path: " + this.hdfsOrcidDefaultPath));
        this.summariesFileNameTarGz = parser.get("summariesFileNameTarGz");
        Log.info((String)("Summaries File Name: " + this.summariesFileNameTarGz));
        this.outputAuthorsPath = parser.get("outputAuthorsPath");
        Log.info((String)("Output Authors Data: " + this.outputAuthorsPath));
    }
}

