/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.orcid.OrcidDSManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.mortbay.log.Log;

public class OrcidDownloader
extends OrcidDSManager {
    static final int REQ_LIMIT = 24;
    static final int RECORD_PARSED_COUNTER_LOG_INTERVAL = 10000;
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final String lastUpdate = "2019-09-30 00:00:00";
    private String lambdaFileName;
    private String outputPath;
    private String token;

    public static void main(String[] args) throws IOException, Exception {
        OrcidDownloader orcidDownloader = new OrcidDownloader();
        orcidDownloader.loadArgs(args);
        orcidDownloader.parseLambdaFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String downloadRecord(String orcidId) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet("https://api.orcid.org/v3.0/" + orcidId + "/record");
            httpGet.addHeader("Accept", "application/vnd.orcid+xml");
            httpGet.addHeader("Authorization", String.format("Bearer %s", this.token));
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                Log.warn((String)("Downloading " + orcidId + " status code: " + response.getStatusLine().getStatusCode()));
                String string2 = new String("");
                return string2;
            }
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        catch (Throwable e) {
            Log.warn((String)("Downloading " + orcidId), (Object)e.getMessage());
            return new String("");
        }
    }

    public void parseLambdaFile() throws Exception {
        int parsedRecordsCounter = 0;
        int downloadedRecordsCounter = 0;
        int savedRecordsCounter = 0;
        long startDownload = 0L;
        Configuration conf = this.initConfigurationObject();
        FileSystem fs = this.initFileSystemObject(conf);
        String lambdaFileUri = this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.lambdaFileName);
        Path hdfsreadpath = new Path(lambdaFileUri);
        FSDataInputStream lambdaFileStream = fs.open(hdfsreadpath);
        Path hdfsoutputPath = new Path(this.hdfsServerUri.concat(this.hdfsOrcidDefaultPath).concat(this.outputPath).concat("orcid_records.seq"));
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)hdfsoutputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)lambdaFileStream));){
            String line;
            int nReqTmp = 0;
            startDownload = System.currentTimeMillis();
            long startReqTmp = System.currentTimeMillis();
            while ((line = br.readLine()) != null) {
                if (++parsedRecordsCounter == 1) continue;
                String[] values = line.split(",");
                List<String> recordInfo = Arrays.asList(values);
                String orcidId = recordInfo.get(0);
                if (this.isModified(orcidId, recordInfo.get(3))) {
                    String record = this.downloadRecord(orcidId);
                    ++downloadedRecordsCounter;
                    if (!record.isEmpty()) {
                        String compressRecord = ArgumentApplicationParser.compressArgument((String)record);
                        Text key = new Text(recordInfo.get(0));
                        Text value = new Text(compressRecord);
                        try {
                            writer.append((Writable)key, (Writable)value);
                            ++savedRecordsCounter;
                        }
                        catch (IOException e) {
                            Log.warn((String)("Writing to sequence file: " + e.getMessage()));
                            Log.warn((Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }
                long endReq = System.currentTimeMillis();
                if (++nReqTmp == 24) {
                    long reqSessionDuration = endReq - startReqTmp;
                    if (reqSessionDuration <= 1000L) {
                        Log.warn((String)("\nreqSessionDuration: " + reqSessionDuration + " nReqTmp: " + nReqTmp + " wait ...."));
                        Thread.sleep(1000L - reqSessionDuration);
                    } else {
                        nReqTmp = 0;
                        startReqTmp = System.currentTimeMillis();
                    }
                }
                if (parsedRecordsCounter % 10000 != 0) continue;
                Log.info((String)("Current parsed: " + parsedRecordsCounter + " downloaded: " + downloadedRecordsCounter + " saved: " + savedRecordsCounter));
            }
            long endDownload = System.currentTimeMillis();
            long downloadTime = endDownload - startDownload;
            Log.info((String)("Download time: " + downloadTime / 1000L / 60L + " minutes"));
        }
        lambdaFileStream.close();
        Log.info((String)("Download started at: " + new Date(startDownload).toString()));
        Log.info((String)("Parsed Records Counter: " + parsedRecordsCounter));
        Log.info((String)("Downloaded Records Counter: " + downloadedRecordsCounter));
        Log.info((String)("Saved Records Counter: " + savedRecordsCounter));
    }

    private void loadArgs(String[] args) throws IOException, Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)OrcidDownloader.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/download_orcid_data.json")));
        parser.parseArgument(args);
        this.hdfsServerUri = parser.get("hdfsServerUri");
        Log.info((String)("HDFS URI: " + this.hdfsServerUri));
        this.hdfsOrcidDefaultPath = parser.get("hdfsOrcidDefaultPath");
        Log.info((String)("Default Path: " + this.hdfsOrcidDefaultPath));
        this.lambdaFileName = parser.get("lambdaFileName");
        Log.info((String)("Lambda File Name: " + this.lambdaFileName));
        this.outputPath = parser.get("outputPath");
        Log.info((String)("Output Data: " + this.outputPath));
        this.token = parser.get("token");
    }

    private boolean isModified(String orcidId, String modifiedDate) {
        Date modifiedDateDt = null;
        Date lastUpdateDt = null;
        try {
            if (modifiedDate.length() != 19) {
                modifiedDate = modifiedDate.substring(0, 19);
            }
            modifiedDateDt = new SimpleDateFormat(DATE_FORMAT).parse(modifiedDate);
            lastUpdateDt = new SimpleDateFormat(DATE_FORMAT).parse(lastUpdate);
        }
        catch (Exception e) {
            Log.warn((String)("[" + orcidId + "] Parsing date: "), (Object)e.getMessage());
            return true;
        }
        return modifiedDateDt.after(lastUpdateDt);
    }
}

