/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.doiboost.orcid.json.JsonWriter;
import eu.dnetlib.doiboost.orcid.model.AuthorData;
import eu.dnetlib.doiboost.orcid.xml.XMLRecordParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.mortbay.log.Log;

public class SummariesDecompressor {
    private static final int MAX_XML_RECORDS_PARSED = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseGzSummaries(Configuration conf, String inputUri, Path outputPath) throws Exception {
        String uri = inputUri;
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        Path inputPath = new Path(uri);
        CompressionCodec codec = factory.getCodec(inputPath);
        if (codec == null) {
            System.err.println("No codec found for " + uri);
            System.exit(1);
        }
        CompressionCodecFactory.removeSuffix((String)uri, (String)codec.getDefaultExtension());
        CompressionInputStream gzipInputStream = null;
        try {
            gzipInputStream = codec.createInputStream((InputStream)fs.open(inputPath));
            SummariesDecompressor.parseTarSummaries(fs, conf, (InputStream)gzipInputStream, outputPath);
        }
        finally {
            Log.debug((String)"Closing gzip stream");
            IOUtils.closeStream((Closeable)gzipInputStream);
        }
    }

    private static void parseTarSummaries(FileSystem fs, Configuration conf, InputStream gzipInputStream, Path outputPath) {
        int counter = 0;
        int nameFound = 0;
        int surnameFound = 0;
        int creditNameFound = 0;
        int errorFromOrcidFound = 0;
        int xmlParserErrorFound = 0;
        try (TarArchiveInputStream tais = new TarArchiveInputStream(gzipInputStream);){
            TarArchiveEntry entry = null;
            try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});){
                while ((entry = tais.getNextTarEntry()) != null) {
                    block38: {
                        String filename = entry.getName();
                        try {
                            String line;
                            if (entry.isDirectory()) {
                                Log.debug((String)("Directory entry name: " + entry.getName()));
                                break block38;
                            }
                            Log.debug((String)("XML record entry name: " + entry.getName()));
                            ++counter;
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tais));
                            StringBuffer buffer = new StringBuffer();
                            while ((line = br.readLine()) != null) {
                                buffer.append(line);
                            }
                            AuthorData authorData = XMLRecordParser.VTDParseAuthorData(buffer.toString().getBytes());
                            if (authorData != null) {
                                if (authorData.getErrorCode() != null) {
                                    ++errorFromOrcidFound;
                                    Log.debug((String)("error from Orcid with code " + authorData.getErrorCode() + " for oid " + entry.getName()));
                                    continue;
                                }
                                String jsonData = JsonWriter.create(authorData);
                                Log.debug((String)("oid: " + authorData.getOid() + " data: " + jsonData));
                                Text key = new Text(authorData.getOid());
                                Text value = new Text(jsonData);
                                try {
                                    writer.append((Writable)key, (Writable)value);
                                }
                                catch (IOException e) {
                                    Log.debug((String)("Writing to sequence file: " + e.getMessage()));
                                    Log.debug((Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                if (authorData.getName() != null) {
                                    ++nameFound;
                                }
                                if (authorData.getSurname() != null) {
                                    ++surnameFound;
                                }
                                if (authorData.getCreditName() != null) {
                                    ++creditNameFound;
                                }
                                break block38;
                            }
                            Log.warn((String)("Data not retrievable [" + entry.getName() + "] " + buffer.toString()));
                            ++xmlParserErrorFound;
                        }
                        catch (Exception e) {
                            Log.warn((String)("Parsing record from tar archive and xml record: " + filename + "  " + e.getMessage()));
                            Log.warn((Throwable)e);
                        }
                    }
                    if (counter % 100000 != 0) continue;
                    Log.info((String)("Current xml records parsed: " + counter));
                }
            }
        }
        catch (IOException e) {
            Log.warn((String)("Parsing record from gzip archive: " + e.getMessage()));
            Log.warn((Throwable)e);
            throw new RuntimeException(e);
        }
        Log.info((String)"Summaries parse completed");
        Log.info((String)("Total XML records parsed: " + counter));
        Log.info((String)("Name found: " + nameFound));
        Log.info((String)("Surname found: " + surnameFound));
        Log.info((String)("Credit name found: " + creditNameFound));
        Log.info((String)("Error from Orcid found: " + errorFromOrcidFound));
        Log.info((String)("Error parsing xml record found: " + xmlParserErrorFound));
    }
}

