/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.dhp.parser.utility.VtdException;
import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import eu.dnetlib.doiboost.orcid.model.AuthorData;
import eu.dnetlib.doiboost.orcid.model.WorkData;
import java.util.Arrays;
import java.util.List;

public class XMLRecordParser {
    private static final String NS_COMMON_URL = "http://www.orcid.org/ns/common";
    private static final String NS_COMMON = "common";
    private static final String NS_PERSON_URL = "http://www.orcid.org/ns/person";
    private static final String NS_PERSON = "person";
    private static final String NS_DETAILS_URL = "http://www.orcid.org/ns/personal-details";
    private static final String NS_DETAILS = "personal-details";
    private static final String NS_OTHER_URL = "http://www.orcid.org/ns/other-name";
    private static final String NS_OTHER = "other-name";
    private static final String NS_RECORD_URL = "http://www.orcid.org/ns/record";
    private static final String NS_RECORD = "record";
    private static final String NS_ERROR_URL = "http://www.orcid.org/ns/error";
    private static final String NS_WORK = "work";
    private static final String NS_WORK_URL = "http://www.orcid.org/ns/work";
    private static final String NS_ERROR = "error";

    public static AuthorData VTDParseAuthorData(byte[] bytes) throws VtdException, EncodingException, EOFException, EntityException, ParseException {
        List creditNames;
        List surnames;
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_PERSON, NS_PERSON_URL);
        ap.declareXPathNameSpace(NS_DETAILS, NS_DETAILS_URL);
        ap.declareXPathNameSpace(NS_OTHER, NS_OTHER_URL);
        ap.declareXPathNameSpace(NS_RECORD, NS_RECORD_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        AuthorData authorData = new AuthorData();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            authorData.setErrorCode((String)errors.get(0));
            return authorData;
        }
        List recordNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//record:record", Arrays.asList("path"));
        if (recordNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)recordNodes.get(0)).getAttributes().get("path")).substring(1);
        authorData.setOid(oid);
        List names = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:given-names");
        if (!names.isEmpty()) {
            authorData.setName((String)names.get(0));
        }
        if (!(surnames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:family-name")).isEmpty()) {
            authorData.setSurname((String)surnames.get(0));
        }
        if (!(creditNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:credit-name")).isEmpty()) {
            authorData.setCreditName((String)creditNames.get(0));
        }
        return authorData;
    }

    public static WorkData VTDParseWorkData(byte[] bytes) throws VtdException, EncodingException, EOFException, EntityException, ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        WorkData workData = new WorkData();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            workData.setErrorCode((String)errors.get(0));
            return workData;
        }
        List workNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//work:work", Arrays.asList("path"));
        if (workNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("path")).split("/")[1];
        workData.setOid(oid);
        List dois = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//common:external-id-type[text()=\"doi\"]/../common:external-id-value");
        if (!dois.isEmpty()) {
            workData.setDoi((String)dois.get(0));
            workData.setDoiFound(true);
        }
        return workData;
    }
}

