/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.doiboost.DoiBoostMappingUtil$;
import eu.dnetlib.doiboost.orcid.ORCIDElement;
import eu.dnetlib.doiboost.orcid.ORCIDItem;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;

public final class ORCIDToOAF$ {
    public static final ORCIDToOAF$ MODULE$;
    private final Logger logger;
    private final ObjectMapper mapper;

    static {
        new ORCIDToOAF$();
    }

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean isJsonValid(String inputStr) {
        boolean bl;
        try {
            this.mapper().readTree(inputStr);
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public Tuple2<String, String> extractValueFromInputString(String input) {
        int i = input.indexOf(91);
        if (i < 5) {
            return null;
        }
        String orcidList = input.substring(i, input.length() - 1);
        String doi = input.substring(1, i - 1);
        return this.isJsonValid(orcidList) ? new Tuple2((Object)doi, (Object)orcidList) : null;
    }

    public Publication convertTOOAF(ORCIDElement input) {
        Publication publication;
        String doi = input.doi();
        Publication pub = new Publication();
        pub.setPid((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{DoiBoostMappingUtil$.MODULE$.createSP(doi, "doi", DoiBoostMappingUtil$.MODULE$.PID_TYPES())}))).asJava());
        pub.setDataInfo(DoiBoostMappingUtil$.MODULE$.generateDataInfo());
        pub.setId(DoiBoostMappingUtil$.MODULE$.generateIdentifier((Result)pub, doi.toLowerCase()));
        try {
            pub.setAuthor((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)input.authors().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Author apply(ORCIDItem a) {
                    return ORCIDToOAF$.MODULE$.generateAuthor(a.name(), a.surname(), a.creditName(), a.oid());
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
            pub.setCollectedfrom((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DoiBoostMappingUtil$.MODULE$.createORIDCollectedFrom()}))).asJava());
            pub.setDataInfo(DoiBoostMappingUtil$.MODULE$.generateDataInfo());
            publication = pub;
        }
        catch (Throwable throwable) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR ON GENERATE Publication from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input})));
            publication = null;
        }
        return publication;
    }

    public Author generateAuthor(String given, String family, String fullName, String orcid) {
        Author a = new Author();
        a.setName(given);
        a.setSurname(family);
        if (fullName != null && new StringOps(Predef$.MODULE$.augmentString(fullName)).nonEmpty()) {
            a.setFullname(fullName);
        } else {
            a.setFullname(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{given, family})));
        }
        if (StringUtils.isNotBlank((String)orcid)) {
            a.setPid((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{DoiBoostMappingUtil$.MODULE$.createSP(orcid, DoiBoostMappingUtil$.MODULE$.ORCID(), DoiBoostMappingUtil$.MODULE$.PID_TYPES())}))).asJava());
        }
        return a;
    }

    private ORCIDToOAF$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
    }
}

