/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.merge.AuthorMerger;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.doiboost.DoiBoostAffiliation;
import eu.dnetlib.doiboost.DoiBoostMappingUtil$;
import eu.dnetlib.doiboost.HostedByItemType;
import eu.dnetlib.doiboost.SparkGenerateDoiBoost$;
import eu.dnetlib.doiboost.mag.ConversionUtil$;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class SparkGenerateDoiBoost$ {
    public static final SparkGenerateDoiBoost$ MODULE$;

    static {
        new SparkGenerateDoiBoost$();
    }

    public void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/doiboost/generate_doiboost_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master(parser.get("master")).getOrCreate();
        String hostedByMapPath = parser.get("hostedByMapPath");
        String workingDirPath = parser.get("workingPath");
        Aggregator<Tuple2<String, Publication>, Publication, Publication> crossrefAggregator = new Aggregator<Tuple2<String, Publication>, Publication, Publication>(){

            public Publication zero() {
                return new Publication();
            }

            public Publication reduce(Publication b, Tuple2<String, Publication> a) {
                block7: {
                    block6: {
                        block5: {
                            if (b != null) break block5;
                            if (a != null && a._2() != null) {
                                ((OafEntity)a._2()).setId((String)a._1());
                                return (Publication)a._2();
                            }
                            break block6;
                        }
                        if (a != null && a._2() != null) break block7;
                    }
                    return new Publication();
                }
                b.mergeFrom((OafEntity)a._2());
                b.setId((String)a._1());
                java.util.List authors = AuthorMerger.mergeAuthor((java.util.List)b.getAuthor(), (java.util.List)((Result)a._2()).getAuthor());
                b.setAuthor(authors);
                return b;
            }

            public Publication merge(Publication b1, Publication b2) {
                block8: {
                    block7: {
                        block6: {
                            if (b1 != null) break block6;
                            if (b2 != null) {
                                return b2;
                            }
                            break block7;
                        }
                        if (b2 != null) break block8;
                    }
                    return new Publication();
                }
                b1.mergeFrom((OafEntity)b2);
                java.util.List authors = AuthorMerger.mergeAuthor((java.util.List)b1.getAuthor(), (java.util.List)b2.getAuthor());
                b1.setAuthor(authors);
                if (b2.getId() != null && new StringOps(Predef$.MODULE$.augmentString(b2.getId())).nonEmpty()) {
                    b1.setId(b2.getId());
                }
                return b1;
            }

            public Publication finish(Publication reduction) {
                return reduction;
            }

            public Encoder<Publication> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Publication.class));
            }

            public Encoder<Publication> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Publication.class));
            }
        };
        Encoder mapEncoderPub = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Publication.class));
        Encoder mapEncoderOrg = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Organization.class));
        Encoder mapEncoderDataset = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Dataset.class));
        Encoder tupleForJoinEncoder = Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), mapEncoderPub);
        Encoder mapEncoderRel = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Relation.class));
        logger.info("Phase 2) Join Crossref with UnpayWall");
        org.apache.spark.sql.Dataset crossrefPublication = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/crossrefPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        org.apache.spark.sql.Dataset uwPublication = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/uwPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        crossrefPublication.joinWith(uwPublication, crossrefPublication.apply("_1").equalTo((Object)uwPublication.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Publication apply(Tuple2<Tuple2<String, Publication>, Tuple2<String, Publication>> item) {
                return SparkGenerateDoiBoost$.MODULE$.eu$dnetlib$doiboost$SparkGenerateDoiBoost$$applyMerge$1(item);
            }
        }, mapEncoderPub).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/firstJoin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
        logger.info("Phase 3) Join Result with ORCID");
        org.apache.spark.sql.Dataset fj = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/firstJoin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        org.apache.spark.sql.Dataset orcidPublication = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/orcidPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        fj.joinWith(orcidPublication, fj.apply("_1").equalTo((Object)orcidPublication.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Publication apply(Tuple2<Tuple2<String, Publication>, Tuple2<String, Publication>> item) {
                return SparkGenerateDoiBoost$.MODULE$.eu$dnetlib$doiboost$SparkGenerateDoiBoost$$applyMerge$1(item);
            }
        }, mapEncoderPub).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/secondJoin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
        logger.info("Phase 4) Join Result with MAG");
        org.apache.spark.sql.Dataset sj = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/secondJoin"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        org.apache.spark.sql.Dataset magPublication = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/magPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder);
        sj.joinWith(magPublication, sj.apply("_1").equalTo((Object)magPublication.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Publication apply(Tuple2<Tuple2<String, Publication>, Tuple2<String, Publication>> item) {
                return SparkGenerateDoiBoost$.MODULE$.eu$dnetlib$doiboost$SparkGenerateDoiBoost$$applyMerge$1(item);
            }
        }, mapEncoderPub).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
        org.apache.spark.sql.Dataset doiBoostPublication = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Publication p) {
                return DoiBoostMappingUtil$.MODULE$.filterPublication(p);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication publication) {
                return DoiBoostMappingUtil$.MODULE$.toISSNPair(publication);
            }
        }, tupleForJoinEncoder);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator63$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("eu.dnetlib.doiboost.HostedByItemType").asType().toTypeConstructor()})));
            }

            public Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator63$1() {
            }
        }
        org.apache.spark.sql.Dataset hostedByDataset = spark.createDataset(spark.sparkContext().textFile(hostedByMapPath, spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, HostedByItemType> apply(String input) {
                return DoiBoostMappingUtil$.MODULE$.toHostedByItem(input);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator63$1())));
        doiBoostPublication.joinWith(hostedByDataset, doiBoostPublication.apply("_1").equalTo((Object)hostedByDataset.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Publication apply(Tuple2<Tuple2<String, Publication>, Tuple2<String, HostedByItemType>> input) {
                return DoiBoostMappingUtil$.MODULE$.fixPublication(input);
            }
        }, mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)p.getId(), (Object)p);
            }
        }, tupleForJoinEncoder).groupByKey((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Publication> x$1) {
                return (String)x$1._1();
            }
        }, spark.implicits().newStringEncoder()).agg(crossrefAggregator.toColumn()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Publication apply(Tuple2<String, Publication> p) {
                return (Publication)p._2();
            }
        }, mapEncoderPub).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostPublicationFiltered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
        String affiliationPath = parser.get("affiliationPath");
        String paperAffiliationPath = parser.get("paperAffiliationPath");
        org.apache.spark.sql.Dataset affiliation = spark.read().load(affiliationPath).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("AffiliationId"), functions$.MODULE$.col("GridId"), functions$.MODULE$.col("OfficialPage"), functions$.MODULE$.col("DisplayName")}));
        org.apache.spark.sql.Dataset paperAffiliation = spark.read().load(paperAffiliationPath).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("AffiliationId").alias("affId"), functions$.MODULE$.col("PaperId")}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator79$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("eu.dnetlib.doiboost.DoiBoostAffiliation").asType().toTypeConstructor();
            }

            public Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator79$1() {
            }
        }
        org.apache.spark.sql.Dataset a = paperAffiliation.joinWith(affiliation, paperAffiliation.apply("affId").equalTo((Object)affiliation.apply("AffiliationId"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1.PaperId"), functions$.MODULE$.col("_2.AffiliationId"), functions$.MODULE$.col("_2.GridId"), functions$.MODULE$.col("_2.OfficialPage"), functions$.MODULE$.col("_2.DisplayName")})).as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Eu_dnetlib_doiboost_SparkGenerateDoiBoost$$typecreator79$1())));
        org.apache.spark.sql.Dataset magPubs = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostPublicationFiltered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath}))).as(mapEncoderPub).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Publication> apply(Publication p) {
                return new Tuple2((Object)ConversionUtil$.MODULE$.extractMagIdentifier((Buffer<String>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala())), (Object)p);
            }
        }, tupleForJoinEncoder).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Publication> s) {
                return s._1() != null;
            }
        });
        magPubs.joinWith(a, magPubs.apply("_1").equalTo((Object)a.apply("PaperId"))).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Relation> apply(Tuple2<Tuple2<String, Publication>, DoiBoostAffiliation> item) {
                Publication pub = (Publication)((Tuple2)item._1())._2();
                DoiBoostAffiliation affiliation = (DoiBoostAffiliation)item._2();
                String affId = affiliation.GridId().isDefined() ? DoiBoostMappingUtil$.MODULE$.generateGridAffiliationId((String)affiliation.GridId().get()) : DoiBoostMappingUtil$.MODULE$.generateMAGAffiliationId(((Object)BoxesRunTime.boxToLong((long)affiliation.AffiliationId())).toString());
                Relation r = new Relation();
                r.setSource(pub.getId());
                r.setTarget(affId);
                r.setRelType("resultOrganization");
                r.setRelClass("hasAuthorInstitution");
                r.setSubRelType("affiliation");
                r.setDataInfo(pub.getDataInfo());
                r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DoiBoostMappingUtil$.MODULE$.createMAGCollectedFrom()}))).asJava());
                Relation r1 = new Relation();
                r1.setTarget(pub.getId());
                r1.setSource(affId);
                r1.setRelType("resultOrganization");
                r1.setRelClass("isAuthorInstitutionOf");
                r1.setSubRelType("affiliation");
                r1.setDataInfo(pub.getDataInfo());
                r1.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DoiBoostMappingUtil$.MODULE$.createMAGCollectedFrom()}))).asJava());
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relation[]{r, r1}));
            }
        }, mapEncoderRel).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostPublicationAffiliation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
        magPubs.joinWith(a, magPubs.apply("_1").equalTo((Object)a.apply("PaperId"))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Organization apply(Tuple2<Tuple2<String, Publication>, DoiBoostAffiliation> item) {
                Organization organization;
                DoiBoostAffiliation affiliation = (DoiBoostAffiliation)item._2();
                if (affiliation.GridId().isEmpty()) {
                    void var3_3;
                    Organization o = new Organization();
                    o.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DoiBoostMappingUtil$.MODULE$.createMAGCollectedFrom()}))).asJava());
                    o.setDataInfo(DoiBoostMappingUtil$.MODULE$.generateDataInfo());
                    o.setId(DoiBoostMappingUtil$.MODULE$.generateMAGAffiliationId(((Object)BoxesRunTime.boxToLong((long)affiliation.AffiliationId())).toString()));
                    o.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToLong((long)affiliation.AffiliationId())).toString()}))).asJava());
                    if (affiliation.DisplayName().nonEmpty()) {
                        o.setLegalname(DoiBoostMappingUtil$.MODULE$.asField(affiliation.DisplayName().get()));
                    }
                    if (affiliation.OfficialPage().isDefined()) {
                        o.setWebsiteurl(DoiBoostMappingUtil$.MODULE$.asField(affiliation.OfficialPage().get()));
                    }
                    o.setCountry(ModelConstants.UNKNOWN_COUNTRY);
                    organization = var3_3;
                } else {
                    organization = null;
                }
                return organization;
            }
        }, mapEncoderOrg).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Organization o) {
                return o != null;
            }
        }).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/doiBoostOrganization"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDirPath})));
    }

    /*
     * WARNING - void declaration
     */
    public final Publication eu$dnetlib$doiboost$SparkGenerateDoiBoost$$applyMerge$1(Tuple2 item) {
        void var2_2;
        Publication otherPub;
        Publication crossrefPub = (Publication)((Tuple2)item._1())._2();
        if (item._2() != null && (otherPub = (Publication)((Tuple2)item._2())._2()) != null) {
            crossrefPub.mergeFrom((OafEntity)otherPub);
            crossrefPub.setAuthor(AuthorMerger.mergeAuthor((java.util.List)crossrefPub.getAuthor(), (java.util.List)otherPub.getAuthor()));
        }
        return var2_2;
    }

    private SparkGenerateDoiBoost$() {
        MODULE$ = this;
    }
}

