/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.doiboost.orcid.model.WorkData;
import eu.dnetlib.doiboost.orcid.xml.XMLRecordParser;
import eu.dnetlib.doiboost.orcidnodoi.json.JsonWriter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.mortbay.log.Log;

public class ActivitiesDecompressor {
    private static final int MAX_XML_WORKS_PARSED = -1;
    private static final int XML_WORKS_PARSED_COUNTER_LOG_INTERVAL = 100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseGzActivities(Configuration conf, String inputUri, Path outputPath) throws Exception {
        String uri = inputUri;
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        Path inputPath = new Path(uri);
        CompressionCodec codec = factory.getCodec(inputPath);
        if (codec == null) {
            System.err.println("No codec found for " + uri);
            System.exit(1);
        }
        CompressionCodecFactory.removeSuffix((String)uri, (String)codec.getDefaultExtension());
        CompressionInputStream gzipInputStream = null;
        try {
            gzipInputStream = codec.createInputStream((InputStream)fs.open(inputPath));
            ActivitiesDecompressor.parseTarActivities(fs, conf, (InputStream)gzipInputStream, outputPath);
        }
        finally {
            Log.debug((String)"Closing gzip stream");
            IOUtils.closeStream((Closeable)gzipInputStream);
        }
    }

    private static void parseTarActivities(FileSystem fs, Configuration conf, InputStream gzipInputStream, Path outputPath) {
        int counter = 0;
        int doiFound = 0;
        int errorFromOrcidFound = 0;
        int xmlParserErrorFound = 0;
        try (TarArchiveInputStream tais = new TarArchiveInputStream(gzipInputStream);){
            TarArchiveEntry entry = null;
            try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});){
                while ((entry = tais.getNextTarEntry()) != null) {
                    block34: {
                        String filename = entry.getName();
                        try {
                            String line;
                            if (entry.isDirectory() || !filename.contains("works")) break block34;
                            Log.debug((String)("XML work entry name: " + entry.getName()));
                            ++counter;
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tais));
                            StringBuffer buffer = new StringBuffer();
                            while ((line = br.readLine()) != null) {
                                buffer.append(line);
                            }
                            WorkData workData = XMLRecordParser.VTDParseWorkData(buffer.toString().getBytes());
                            if (workData != null) {
                                if (workData.getErrorCode() != null) {
                                    ++errorFromOrcidFound;
                                    Log.debug((String)("error from Orcid with code " + workData.getErrorCode() + " for entry " + entry.getName()));
                                    continue;
                                }
                                if (!workData.isDoiFound()) break block34;
                                String jsonData = JsonWriter.create(workData);
                                Log.debug((String)("oid: " + workData.getOid() + " data: " + jsonData));
                                Text key = new Text(workData.getOid());
                                Text value = new Text(jsonData);
                                try {
                                    writer.append((Writable)key, (Writable)value);
                                }
                                catch (IOException e) {
                                    Log.debug((String)("Writing to sequence file: " + e.getMessage()));
                                    Log.debug((Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                ++doiFound;
                                break block34;
                            }
                            Log.warn((String)("Data not retrievable [" + entry.getName() + "] " + buffer));
                            ++xmlParserErrorFound;
                        }
                        catch (Exception e) {
                            Log.warn((String)("Parsing work from tar archive and xml work: " + filename + "  " + e.getMessage()));
                            Log.warn((Throwable)e);
                        }
                    }
                    if (counter % 100000 != 0) continue;
                    Log.info((String)("Current xml works parsed: " + counter));
                }
            }
        }
        catch (IOException e) {
            Log.warn((String)("Parsing work from gzip archive: " + e.getMessage()));
            Log.warn((Throwable)e);
            throw new RuntimeException(e);
        }
        Log.info((String)"Activities parse completed");
        Log.info((String)("Total XML works parsed: " + counter));
        Log.info((String)("Total doi found: " + doiFound));
        Log.info((String)("Error from Orcid found: " + errorFromOrcidFound));
        Log.info((String)("Error parsing xml work found: " + xmlParserErrorFound));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractXML(Configuration conf, String inputUri, Path outputPath) throws Exception {
        String uri = inputUri;
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        Path inputPath = new Path(uri);
        CompressionCodec codec = factory.getCodec(inputPath);
        if (codec == null) {
            System.err.println("No codec found for " + uri);
            System.exit(1);
        }
        CompressionCodecFactory.removeSuffix((String)uri, (String)codec.getDefaultExtension());
        CompressionInputStream gzipInputStream = null;
        try {
            gzipInputStream = codec.createInputStream((InputStream)fs.open(inputPath));
            int counter = 0;
            try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)gzipInputStream);){
                TarArchiveEntry entry = null;
                try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new GzipCodec())});){
                    while ((entry = tais.getNextTarEntry()) != null) {
                        String line;
                        String filename = entry.getName();
                        if (entry.isDirectory() || !filename.contains("works")) continue;
                        ++counter;
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tais));
                        StringBuffer buffer = new StringBuffer();
                        while ((line = br.readLine()) != null) {
                            buffer.append(line);
                        }
                        String xml = buffer.toString();
                        String[] filenameParts = filename.split("/");
                        Text key = new Text(XMLRecordParser.retrieveOrcidIdFromActivity(xml.getBytes(), filenameParts[filenameParts.length - 1]));
                        Text value = new Text(xml);
                        writer.append((Writable)key, (Writable)value);
                        if (counter % 100000 != 0) continue;
                        Log.info((String)("Current xml works extracted: " + counter));
                    }
                }
            }
            Log.info((String)"Activities extraction completed");
            Log.info((String)("Total XML works parsed: " + counter));
        }
        finally {
            Log.debug((String)"Closing gzip stream");
            IOUtils.closeStream((Closeable)gzipInputStream);
        }
    }
}

