/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.orcid.OrcidDSManager;
import eu.dnetlib.doiboost.orcidnodoi.ActivitiesDumpReader;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.mortbay.log.Log;

public class GenOrcidAuthorWork
extends OrcidDSManager {
    private String activitiesFileNameTarGz;
    private String outputWorksPath;

    public static void main(String[] args) throws Exception {
        GenOrcidAuthorWork genOrcidAuthorWork = new GenOrcidAuthorWork();
        genOrcidAuthorWork.loadArgs(args);
        genOrcidAuthorWork.generateAuthorsDOIsData();
    }

    public void generateAuthorsDOIsData() throws Exception {
        Configuration conf = this.initConfigurationObject();
        FileSystem fs = this.initFileSystemObject(conf);
        String tarGzUri = this.hdfsServerUri.concat(this.workingPath).concat(this.activitiesFileNameTarGz);
        Path outputPath = new Path(this.hdfsServerUri.concat(this.workingPath).concat(this.outputWorksPath));
        ActivitiesDumpReader.parseGzActivities(conf, tarGzUri, outputPath);
    }

    private void loadArgs(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenOrcidAuthorWork.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/gen_orcid_works-no-doi_from_activities.json")));
        parser.parseArgument(args);
        this.hdfsServerUri = parser.get("hdfsServerUri");
        Log.info((String)("HDFS URI: " + this.hdfsServerUri));
        this.workingPath = parser.get("workingPath");
        Log.info((String)("Working Path: " + this.workingPath));
        this.activitiesFileNameTarGz = parser.get("activitiesFileNameTarGz");
        Log.info((String)("Activities File Name: " + this.activitiesFileNameTarGz));
        this.outputWorksPath = parser.get("outputWorksPath");
        Log.info((String)("Output Author Work Data: " + this.outputWorksPath));
    }
}

