/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import eu.dnetlib.dhp.parser.utility.VtdException;
import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import eu.dnetlib.dhp.schema.orcid.Contributor;
import eu.dnetlib.dhp.schema.orcid.ExternalId;
import eu.dnetlib.dhp.schema.orcid.PublicationDate;
import eu.dnetlib.dhp.schema.orcid.WorkDetail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLRecordParserNoDoi {
    private static final Logger logger = LoggerFactory.getLogger(XMLRecordParserNoDoi.class);
    private static final String NS_COMMON_URL = "http://www.orcid.org/ns/common";
    private static final String NS_COMMON = "common";
    private static final String NS_PERSON_URL = "http://www.orcid.org/ns/person";
    private static final String NS_PERSON = "person";
    private static final String NS_DETAILS_URL = "http://www.orcid.org/ns/personal-details";
    private static final String NS_DETAILS = "personal-details";
    private static final String NS_OTHER_URL = "http://www.orcid.org/ns/other-name";
    private static final String NS_OTHER = "other-name";
    private static final String NS_RECORD_URL = "http://www.orcid.org/ns/record";
    private static final String NS_RECORD = "record";
    private static final String NS_ERROR_URL = "http://www.orcid.org/ns/error";
    private static final String NS_WORK = "work";
    private static final String NS_WORK_URL = "http://www.orcid.org/ns/work";
    private static final String NS_ERROR = "error";

    public static WorkDetail VTDParseWorkData(byte[] bytes) throws VtdException, ParseException, XPathParseException, NavException, XPathEvalException {
        List urls;
        List types;
        List sourceNames;
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        WorkDetail workData = new WorkDetail();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            workData.setErrorCode((String)errors.get(0));
            return workData;
        }
        List workNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//work:work", Arrays.asList("path", "put-code"));
        if (workNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("path")).split("/")[1];
        workData.setOid(oid);
        String id = (String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("put-code");
        workData.setId(id);
        List titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//common:title");
        if (!titles.isEmpty()) {
            workData.setTitles(titles);
        }
        if (!(sourceNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//common:source-name")).isEmpty()) {
            workData.setSourceName((String)sourceNames.get(0));
        }
        if (!(types = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//work:type")).isEmpty()) {
            workData.setType((String)types.get(0));
        }
        if (!(urls = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//common:url")).isEmpty()) {
            workData.setUrls(urls);
        }
        workData.setPublicationDates(XMLRecordParserNoDoi.getPublicationDates(vg, vn, ap));
        workData.setExtIds(XMLRecordParserNoDoi.getExternalIds(vg, vn, ap));
        workData.setContributors(XMLRecordParserNoDoi.getContributors(vg, vn, ap));
        return workData;
    }

    private static List<PublicationDate> getPublicationDates(VTDGen vg, VTDNav vn, AutoPilot ap) throws XPathParseException, NavException, XPathEvalException {
        int t;
        ArrayList<PublicationDate> publicationDates = new ArrayList<PublicationDate>();
        int yearIndex = 0;
        ap.selectXPath("//common:publication-date/common:year");
        while (ap.evalXPath() != -1) {
            PublicationDate publicationDate = new PublicationDate();
            t = vn.getText();
            if (t < 0) continue;
            publicationDate.setYear(vn.toNormalizedString(t));
            publicationDates.add(yearIndex, publicationDate);
            ++yearIndex;
        }
        int monthIndex = 0;
        ap.selectXPath("//common:publication-date/common:month");
        while (ap.evalXPath() != -1) {
            t = vn.getText();
            if (t < 0) continue;
            ((PublicationDate)publicationDates.get(monthIndex)).setMonth(vn.toNormalizedString(t));
            ++monthIndex;
        }
        int dayIndex = 0;
        ap.selectXPath("//common:publication-date/common:day");
        while (ap.evalXPath() != -1) {
            int t2 = vn.getText();
            if (t2 < 0) continue;
            ((PublicationDate)publicationDates.get(dayIndex)).setDay(vn.toNormalizedString(t2));
            ++dayIndex;
        }
        return publicationDates;
    }

    private static List<ExternalId> getExternalIds(VTDGen vg, VTDNav vn, AutoPilot ap) throws XPathParseException, NavException, XPathEvalException {
        int t;
        ArrayList<ExternalId> extIds = new ArrayList<ExternalId>();
        int typeIndex = 0;
        ap.selectXPath("//common:external-id/common:external-id-type");
        while (ap.evalXPath() != -1) {
            ExternalId extId = new ExternalId();
            t = vn.getText();
            if (t < 0) continue;
            extId.setType(vn.toNormalizedString(t));
            extIds.add(typeIndex, extId);
            ++typeIndex;
        }
        int valueIndex = 0;
        ap.selectXPath("//common:external-id/common:external-id-value");
        while (ap.evalXPath() != -1) {
            t = vn.getText();
            if (t < 0) continue;
            ((ExternalId)extIds.get(valueIndex)).setValue(vn.toNormalizedString(t));
            ++valueIndex;
        }
        int relationshipIndex = 0;
        ap.selectXPath("//common:external-id/common:external-id-relationship");
        while (ap.evalXPath() != -1) {
            int t2 = vn.getText();
            if (t2 < 0) continue;
            ((ExternalId)extIds.get(relationshipIndex)).setRelationShip(vn.toNormalizedString(t2));
            ++relationshipIndex;
        }
        if (typeIndex == valueIndex) {
            return extIds;
        }
        return new ArrayList<ExternalId>();
    }

    private static List<Contributor> getContributors(VTDGen vg, VTDNav vn, AutoPilot ap) throws XPathParseException, NavException, XPathEvalException {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        ap.selectXPath("//work:contributors/work:contributor");
        while (ap.evalXPath() != -1) {
            int val;
            Contributor contributor = new Contributor();
            if (vn.toElement(2, "work:credit-name")) {
                val = vn.getText();
                if (val != -1) {
                    contributor.setCreditName(vn.toNormalizedString(val));
                }
                vn.toElement(1);
            }
            if (vn.toElement(2, "work:contributor-attributes")) {
                if (vn.toElement(2, "work:contributor-sequence")) {
                    val = vn.getText();
                    if (val != -1) {
                        contributor.setSequence(vn.toNormalizedString(val));
                    }
                    vn.toElement(1);
                }
                if (vn.toElement(2, "work:contributor-role")) {
                    val = vn.getText();
                    if (val != -1) {
                        contributor.setRole(vn.toNormalizedString(val));
                    }
                    vn.toElement(1);
                }
                vn.toElement(1);
            }
            contributors.add(contributor);
        }
        return contributors;
    }
}

