/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.orcid.OrcidDSManager;
import eu.dnetlib.doiboost.orcid.SummariesDecompressor;
import eu.dnetlib.doiboost.orcidnodoi.GenOrcidAuthorWork;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.mortbay.log.Log;

public class ExtractXMLSummariesData
extends OrcidDSManager {
    private String outputAuthorsPath;
    private String summariesFileNameTarGz;

    public static void main(String[] args) throws Exception {
        ExtractXMLSummariesData extractXMLSummariesData = new ExtractXMLSummariesData();
        extractXMLSummariesData.loadArgs(args);
        extractXMLSummariesData.extractAuthors();
    }

    private void loadArgs(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenOrcidAuthorWork.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/gen_orcid_authors_from_summaries.json")));
        parser.parseArgument(args);
        this.hdfsServerUri = parser.get("hdfsServerUri");
        Log.info((String)("HDFS URI: " + this.hdfsServerUri));
        this.workingPath = parser.get("workingPath");
        Log.info((String)("Working Path: " + this.workingPath));
        this.summariesFileNameTarGz = parser.get("summariesFileNameTarGz");
        Log.info((String)("Summaries File Name: " + this.summariesFileNameTarGz));
        this.outputAuthorsPath = parser.get("outputAuthorsPath");
        Log.info((String)("Output Authors Data: " + this.outputAuthorsPath));
    }

    public void extractAuthors() throws Exception {
        Configuration conf = this.initConfigurationObject();
        FileSystem fs = this.initFileSystemObject(conf);
        String tarGzUri = this.hdfsServerUri.concat(this.workingPath).concat(this.summariesFileNameTarGz);
        Path outputPath = new Path(this.hdfsServerUri.concat(this.workingPath).concat(this.outputAuthorsPath).concat("xml_authors.seq"));
        SummariesDecompressor.extractXML(conf, tarGzUri, outputPath);
    }
}

