/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.crossref;

import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.doiboost.crossref.Crossref2Oaf$;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001-\u00111c\u0011:pgN\u0014XMZ'baBLgn\u001a+fgRT!a\u0001\u0003\u0002\u0011\r\u0014xn]:sK\u001aT!!\u0002\u0004\u0002\u0011\u0011|\u0017NY8pgRT!a\u0002\u0005\u0002\u000f\u0011tW\r\u001e7jE*\t\u0011\"\u0001\u0002fk\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u0019awnZ4feV\t!\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)1\u000f\u001c45U*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\r1{wmZ3s\u0011\u0019\u0019\u0003\u0001)A\u00055\u00059An\\4hKJ\u0004\u0003bB\u0013\u0001\u0005\u0004%\tAJ\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u0003\u001d\u0002\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u00075\f\u0007O\u0003\u0002-[\u00059!.Y2lg>t'B\u0001\u0018\u001f\u0003!\u0019w\u000eZ3iCV\u001c\u0018B\u0001\u0019*\u00051y%M[3di6\u000b\u0007\u000f]3s\u0011\u0019\u0011\u0004\u0001)A\u0005O\u00059Q.\u00199qKJ\u0004\u0003\"\u0002\u001b\u0001\t\u0003)\u0014A\b;fgR4UO\u001c3feJ+G.\u0019;j_:\u001c\b.\u001b9t\u001b\u0006\u0004\b/\u001b8h)\u00051\u0004CA\u00078\u0013\tAdB\u0001\u0003V]&$\bFA\u001a;!\tY$)D\u0001=\u0015\tid(A\u0002ba&T!a\u0010!\u0002\u000f),\b/\u001b;fe*\u0011\u0011IH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0007r\u0012A\u0001V3ti\")Q\t\u0001C\u0001\r\u0006i1\r[3dWJ+G.\u0019;j_:$\"AN$\t\u000b!#\u0005\u0019A%\u0002\u0019\u001d,g.\u001a:bi\u0016$w*\u0011$\u0011\u0007)\u0013VK\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011aJC\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0015\b\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002R\u001dA\u0011a+X\u0007\u0002/*\u0011\u0001,W\u0001\u0004_\u00064'B\u0001.\\\u0003\u0019\u00198\r[3nC*\u0011ALB\u0001\u0004I\"\u0004\u0018B\u00010X\u0005\ry\u0015M\u001a\u0005\u0006A\u0002!\t!N\u0001\bi\u0016\u001cHoU;nQ\ty&\bC\u0003d\u0001\u0011\u0005Q'A\u0006uKN$xJ]2jI&#\u0005F\u00012;\u0011\u00151\u0007\u0001\"\u00016\u00039!Xm\u001d;F[B$\u0018\u0010V5uY\u0016D#!\u001a\u001e\t\u000b%\u0004A\u0011A\u001b\u0002!Q,7\u000f\u001e)fKJ\u0014VM^5fo\u0016$\u0007F\u00015;\u0011\u0015a\u0007\u0001\"\u0001n\u00039)\u0007\u0010\u001e:bGR,5)Q<be\u0012$\"A\\;\u0011\u0005=\u0014hBA\u0007q\u0013\t\th\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9\u000f\u0011\u001518\u000e1\u0001o\u0003\u0015\tw/\u0019:e\u0011\u0015A\b\u0001\"\u00016\u00035)\u0007\u0010\u001e:bGR,5\tV3ti\"\u0012qO\u000f\u0005\u0006w\u0002!\t!N\u0001\u0014i\u0016\u001cHOS8ve:\fGNU3mCRLwN\u001c\u0015\u0003ujBQA \u0001\u0005\u0002U\nq\u0004^3ti\u000e{gN^3si\n{wn\u001b$s_6\u001c%o\\:t%\u00164'gT1gQ\ti(\b\u0003\u0004\u0002\u0004\u0001!\t!N\u0001$i\u0016\u001cHoQ8om\u0016\u0014H\u000f\u0015:faJLg\u000e\u001e$s_6\u001c%o\\:t%\u00164'gT1gQ\r\t\tA\u000f\u0005\u0007\u0003\u0013\u0001A\u0011A\u001b\u0002EQ,7\u000f^\"p]Z,'\u000f\u001e#bi\u0006\u001cX\r\u001e$s_6\u001c%o\\:t%\u00164'gT1gQ\r\t9A\u000f\u0005\u0007\u0003\u001f\u0001A\u0011A\u001b\u0002EQ,7\u000f^\"p]Z,'\u000f^!si&\u001cG.\u001a$s_6\u001c%o\\:t%\u00164'gT1gQ\r\tiA\u000f\u0005\u0007\u0003+\u0001A\u0011A\u001b\u0002GQ,7\u000f^*fi\u0012\u000bG/Z(g\u0003\u000e\u001cW\r\u001d;b]\u000e,7I]8tgJ+gMM(bM\"\u001a\u00111\u0003\u001e\t\r\u0005m\u0001\u0001\"\u00016\u0003A!Xm\u001d;O_Jl\u0017\r\\5{K\u0012{\u0015\nK\u0002\u0002\u001aiBa!!\t\u0001\t\u0003)\u0014!\u0005;fgRtuN]7bY&TX\rR(Je!\u001a\u0011q\u0004\u001e\t\r\u0005\u001d\u0002\u0001\"\u00016\u0003Q!Xm\u001d;MS\u000e,gn]3W_J\u001cEn\\:fI\"\u001a\u0011Q\u0005\u001e\t\r\u00055\u0002\u0001\"\u00016\u0003=!Xm\u001d;MS\u000e,gn]3Pa\u0016t\u0007fAA\u0016u!1\u00111\u0007\u0001\u0005\u0002U\na\u0003^3ti2K7-\u001a8tK\u0016k'-\u0019:h_>\u0003XM\u001c\u0015\u0004\u0003cQ\u0004BBA\u001d\u0001\u0011\u0005Q'\u0001\nuKN$H*[2f]N,W)\u001c2be\u001e|\u0007fAA\u001cu!1\u0011q\b\u0001\u0005\u0002U\n!\u0004^3ti2K7-\u001a8tK\u0016k'-\u0019:h_\u0012\u000bG/\u001a+j[\u0016D3!!\u0010;\u0011\u0019\t)\u0005\u0001C\u0001k\u0005\u0001B/Z:u\u001bVdG/\u001b9mKV\u0013Fj\u001d\u0015\u0004\u0003\u0007R\u0004")
public class CrossrefMappingTest {
    private final Logger logger = LoggerFactory.getLogger(Crossref2Oaf$.MODULE$.getClass());
    private final ObjectMapper mapper = new ObjectMapper();

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Test
    public void testFunderRelationshipsMapping() {
        String template = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("article_funder_template.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        String funder_doi = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("funder_doi"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        String funder_name = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("funder_doi"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(funder_doi)).lines().foreach((Function1)new Serializable(this, template){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;
            private final String template$1;

            public final void apply(String line) {
                String json = this.template$1.replace("%s", line);
                List resultList = Crossref2Oaf$.MODULE$.convert(json);
                Assertions.assertTrue((boolean)resultList.nonEmpty());
                this.$outer.checkRelation((List<Oaf>)resultList);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.template$1 = template$1;
            }
        });
        new StringOps(Predef$.MODULE$.augmentString(funder_name)).lines().foreach((Function1)new Serializable(this, template){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;
            private final String template$1;

            public final void apply(String line) {
                String json = this.template$1.replace("%s", line);
                List resultList = Crossref2Oaf$.MODULE$.convert(json);
                Assertions.assertTrue((boolean)resultList.nonEmpty());
                this.$outer.checkRelation((List<Oaf>)resultList);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.template$1 = template$1;
            }
        });
    }

    public void checkRelation(List<Oaf> generatedOAF) {
        List rels = (List)generatedOAF.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Relation;
            }
        });
        Assertions.assertFalse((boolean)rels.isEmpty());
        rels.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Relation relation) {
                String relJson = this.$outer.mapper().writeValueAsString((Object)relation);
                Assertions.assertNotNull((Object)relation.getSource(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source of relation null ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
                Assertions.assertNotNull((Object)relation.getTarget(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target of relation null ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
                Assertions.assertFalse((boolean)relation.getTarget().isEmpty(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target is empty: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
                Assertions.assertFalse((boolean)relation.getRelClass().isEmpty(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RelClass is empty: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
                Assertions.assertFalse((boolean)relation.getRelType().isEmpty(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RelType is empty: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
                Assertions.assertFalse((boolean)relation.getSubRelType().isEmpty(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SubRelType is empty: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relJson})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testSum() {
        long from = 1613135645000L;
        long delta = 1000000L;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updating from value: ", "  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)(from + delta))})));
    }

    @Test
    public void testOrcidID() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("orcid_data.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        });
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        items.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Oaf p) {
                Predef$.MODULE$.println((Object)this.$outer.mapper().writeValueAsString((Object)p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testEmptyTitle() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("empty_title.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        });
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        items.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Oaf p) {
                Predef$.MODULE$.println((Object)this.$outer.mapper().writeValueAsString((Object)p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPeerReviewed() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("prwTest.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        });
        items.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Oaf p) {
                this.$outer.logger().info(this.$outer.mapper().writeValueAsString((Object)p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String extractECAward(String award) {
        Regex awardECRegex = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4,9}")).r();
        if (awardECRegex.findAllIn((CharSequence)award).hasNext()) {
            return (String)awardECRegex.findAllIn((CharSequence)award).max((Ordering)Ordering.String$.MODULE$);
        }
        return null;
    }

    @Test
    public void extractECTest() {
        String s = "FP7/2007-2013";
        String awardExtracted = this.extractECAward(s);
        Predef$.MODULE$.println((Object)awardExtracted);
        Predef$.MODULE$.println((Object)DHPUtils.md5((String)awardExtracted));
    }

    @Test
    public void testJournalRelation() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("awardTest.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List rels = (List)((List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Relation;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Relation apply(Oaf r) {
                return (Relation)r;
            }
        }, List$.MODULE$.canBuildFrom());
        rels.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Relation s) {
                this.$outer.logger().info(s.getTarget());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((int)rels.size(), (int)6);
    }

    @Test
    public void testConvertBookFromCrossRef2Oaf() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("book.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        });
        Predef$.MODULE$.assert(items.nonEmpty());
        Predef$.MODULE$.assert(items.size() == 1);
        Result result = (Result)items.head();
        Assertions.assertNotNull((Object)result);
        this.logger().info(this.mapper().writeValueAsString((Object)result));
        Assertions.assertNotNull((Object)result.getDataInfo(), (String)"Datainfo test not null Failed");
        Assertions.assertNotNull((Object)result.getDataInfo().getProvenanceaction(), (String)"DataInfo/Provenance test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassid().isEmpty(), (String)"DataInfo/Provenance/classId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassname().isEmpty(), (String)"DataInfo/Provenance/className test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemeid().isEmpty(), (String)"DataInfo/Provenance/SchemeId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemename().isEmpty(), (String)"DataInfo/Provenance/SchemeName test not null Failed");
        Assertions.assertNotNull((Object)result.getCollectedfrom(), (String)"CollectedFrom test not null Failed");
        Assertions.assertFalse((boolean)result.getCollectedfrom().isEmpty());
        Buffer collectedFromList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getCollectedfrom()).asScala();
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getKey().equalsIgnoreCase("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getValue().equalsIgnoreCase("crossref");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Buffer relevantDates = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getRelevantdate()).asScala();
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("created");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type created";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("published-online");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type published-online";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("published-print");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type published-print";
            }
        });
        List rels = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Relation;
            }
        });
        Predef$.MODULE$.assert(rels.isEmpty());
    }

    @Test
    public void testConvertPreprintFromCrossRef2Oaf() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("preprint.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Publication;
            }
        });
        Predef$.MODULE$.assert(items.nonEmpty());
        Predef$.MODULE$.assert(items.size() == 1);
        Publication result = (Publication)items.head();
        Assertions.assertNotNull((Object)result);
        this.logger().info(this.mapper().writeValueAsString((Object)result));
        Assertions.assertNotNull((Object)result.getDataInfo(), (String)"Datainfo test not null Failed");
        Assertions.assertNotNull((Object)result.getDataInfo().getProvenanceaction(), (String)"DataInfo/Provenance test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassid().isEmpty(), (String)"DataInfo/Provenance/classId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassname().isEmpty(), (String)"DataInfo/Provenance/className test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemeid().isEmpty(), (String)"DataInfo/Provenance/SchemeId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemename().isEmpty(), (String)"DataInfo/Provenance/SchemeName test not null Failed");
        Assertions.assertNotNull((Object)result.getCollectedfrom(), (String)"CollectedFrom test not null Failed");
        Assertions.assertFalse((boolean)result.getCollectedfrom().isEmpty());
        Buffer collectedFromList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getCollectedfrom()).asScala();
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getKey().equalsIgnoreCase("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getValue().equalsIgnoreCase("crossref");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Buffer relevantDates = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getRelevantdate()).asScala();
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("created");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type created";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("available");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type available";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("accepted");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type accepted";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("published-online");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type published-online";
            }
        });
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("published-print");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type published-print";
            }
        });
        List rels = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Relation;
            }
        });
        Predef$.MODULE$.assert(rels.isEmpty());
    }

    @Test
    public void testConvertDatasetFromCrossRef2Oaf() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("dataset.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Dataset;
            }
        });
        Predef$.MODULE$.assert(items.nonEmpty());
        Predef$.MODULE$.assert(items.size() == 1);
        Dataset result = (Dataset)items.head();
        Assertions.assertNotNull((Object)result);
        this.logger().info(this.mapper().writeValueAsString((Object)result));
        Assertions.assertNotNull((Object)result.getDataInfo(), (String)"Datainfo test not null Failed");
        Assertions.assertNotNull((Object)result.getDataInfo().getProvenanceaction(), (String)"DataInfo/Provenance test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassid().isEmpty(), (String)"DataInfo/Provenance/classId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassname().isEmpty(), (String)"DataInfo/Provenance/className test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemeid().isEmpty(), (String)"DataInfo/Provenance/SchemeId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemename().isEmpty(), (String)"DataInfo/Provenance/SchemeName test not null Failed");
        Assertions.assertNotNull((Object)result.getCollectedfrom(), (String)"CollectedFrom test not null Failed");
        Assertions.assertFalse((boolean)result.getCollectedfrom().isEmpty());
    }

    @Test
    public void testConvertArticleFromCrossRef2Oaf() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("article.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Publication;
            }
        });
        Predef$.MODULE$.assert(items.nonEmpty());
        Predef$.MODULE$.assert(items.size() == 1);
        Publication result = (Publication)items.head();
        Assertions.assertNotNull((Object)result);
        this.logger().info(this.mapper().writeValueAsString((Object)result));
        Assertions.assertNotNull((Object)result.getDataInfo(), (String)"Datainfo test not null Failed");
        Assertions.assertNotNull((Object)result.getDataInfo().getProvenanceaction(), (String)"DataInfo/Provenance test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassid().isEmpty(), (String)"DataInfo/Provenance/classId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getClassname().isEmpty(), (String)"DataInfo/Provenance/className test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemeid().isEmpty(), (String)"DataInfo/Provenance/SchemeId test not null Failed");
        Assertions.assertFalse((boolean)result.getDataInfo().getProvenanceaction().getSchemename().isEmpty(), (String)"DataInfo/Provenance/SchemeName test not null Failed");
        Assertions.assertNotNull((Object)result.getCollectedfrom(), (String)"CollectedFrom test not null Failed");
        Assertions.assertFalse((boolean)result.getCollectedfrom().isEmpty());
        Buffer collectedFromList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getCollectedfrom()).asScala();
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getKey().equalsIgnoreCase("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Predef$.MODULE$.assert(collectedFromList.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue c) {
                return c.getValue().equalsIgnoreCase("crossref");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong collected from assertion";
            }
        });
        Buffer relevantDates = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getRelevantdate()).asScala();
        Predef$.MODULE$.assert(relevantDates.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty d) {
                return d.getQualifier().getClassid().equalsIgnoreCase("created");
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Missing relevant date of type created";
            }
        });
        List rels = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Relation;
            }
        });
        Assertions.assertFalse((boolean)rels.isEmpty());
        rels.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Relation relation) {
                Assertions.assertNotNull((Object)relation);
                Assertions.assertFalse((boolean)relation.getSource().isEmpty());
                Assertions.assertFalse((boolean)relation.getTarget().isEmpty());
                Assertions.assertFalse((boolean)relation.getRelClass().isEmpty());
                Assertions.assertFalse((boolean)relation.getRelType().isEmpty());
                Assertions.assertFalse((boolean)relation.getSubRelType().isEmpty());
            }
        });
    }

    @Test
    public void testSetDateOfAcceptanceCrossRef2Oaf() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("dump_file.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Publication;
            }
        });
        Predef$.MODULE$.assert(items.nonEmpty());
        Predef$.MODULE$.assert(items.size() == 1);
        Publication result = (Publication)items.head();
        Assertions.assertNotNull((Object)result);
        this.logger().info(this.mapper().writeValueAsString((Object)result));
    }

    @Test
    public void testNormalizeDOI() {
        String template = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("article_funder_template.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        String line = "\"funder\": [{\"name\": \"Wellcome Trust Masters Fellowship\",\"award\": [\"090633\"]}],";
        String json = template.replace("%s", line);
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Publication;
            }
        });
        Publication result = (Publication)items.head();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getPid()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Assertions.assertTrue((boolean)pid.getQualifier().getClassid().equals("doi"));
            }
        });
        Assertions.assertTrue((result.getPid().size() == 1 ? 1 : 0) != 0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getPid()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Assertions.assertTrue((boolean)pid.getValue().equals("10.26850/1678-4618EQJ.v35.1.2010.p41-46".toLowerCase()));
            }
        });
    }

    @Test
    public void testNormalizeDOI2() {
        String template = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("article.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List resultList = Crossref2Oaf$.MODULE$.convert(template);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        List items = (List)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Publication;
            }
        });
        Publication result = (Publication)items.head();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getPid()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Assertions.assertTrue((boolean)pid.getQualifier().getClassid().equals("doi"));
            }
        });
        Assertions.assertTrue((result.getPid().size() == 1 ? 1 : 0) != 0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getPid()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Assertions.assertTrue((boolean)pid.getValue().equals("10.26850/1678-4618EQJ.v35.1.2010.p41-46".toLowerCase()));
            }
        });
    }

    @Test
    public void testLicenseVorClosed() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("publication_license_vor.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)item));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((String)i.getLicense().getValue()).equals("https://www.springer.com/vor");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getClassid().equals("CLOSED");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getOpenAccessRoute() == null;
            }
        }));
    }

    @Test
    public void testLicenseOpen() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("publication_license_open.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((String)i.getLicense().getValue()).equals("http://pubs.acs.org/page/policy/authorchoice_ccby_termsofuse.html");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getClassid().equals("OPEN");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                OpenAccessRoute openAccessRoute = i.getAccessright().getOpenAccessRoute();
                OpenAccessRoute openAccessRoute2 = OpenAccessRoute.hybrid;
                return !(openAccessRoute != null ? !openAccessRoute.equals(openAccessRoute2) : openAccessRoute2 != null);
            }
        }));
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)item));
    }

    @Test
    public void testLicenseEmbargoOpen() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("publication_license_embargo_open.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((String)i.getLicense().getValue()).equals("https://academic.oup.com/journals/pages/open_access/funder_policies/chorus/standard_publication_model");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getClassid().equals("OPEN");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                OpenAccessRoute openAccessRoute = i.getAccessright().getOpenAccessRoute();
                OpenAccessRoute openAccessRoute2 = OpenAccessRoute.hybrid;
                return !(openAccessRoute != null ? !openAccessRoute.equals(openAccessRoute2) : openAccessRoute2 != null);
            }
        }));
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)item));
    }

    @Test
    public void testLicenseEmbargo() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("publication_license_embargo.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((String)i.getLicense().getValue()).equals("https://academic.oup.com/journals/pages/open_access/funder_policies/chorus/standard_publication_model");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getClassid().equals("EMBARGO");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getOpenAccessRoute() == null;
            }
        }));
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)item));
    }

    @Test
    public void testLicenseEmbargoDateTime() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("publication_license_embargo_datetime.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((String)i.getLicense().getValue()).equals("https://academic.oup.com/journals/pages/open_access/funder_policies/chorus/standard_publication_model");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getClassid().equals("EMBARGO");
            }
        }));
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getAccessright().getOpenAccessRoute() == null;
            }
        }));
        this.mapper().getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)item));
    }

    @Test
    public void testMultipleURLs() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("multiple_urls.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        List resultList = Crossref2Oaf$.MODULE$.convert(json);
        Assertions.assertTrue((boolean)resultList.nonEmpty());
        Result item = (Result)((IterableLike)resultList.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf p) {
                return p instanceof Result;
            }
        })).head();
        Assertions.assertEquals((int)1, (int)item.getInstance().size());
        Assertions.assertEquals((int)1, (int)((Instance)item.getInstance().get(0)).getUrl().size());
        Assertions.assertEquals((Object)"https://doi.org/10.1016/j.jas.2019.105013", ((Instance)item.getInstance().get(0)).getUrl().get(0));
    }
}

