/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.doiboost.orcid.MappingORCIDToOAFTest$;
import eu.dnetlib.doiboost.orcid.ORCIDItem;
import eu.dnetlib.doiboost.orcid.ORCIDToOAF$;
import eu.dnetlib.doiboost.orcid.OrcidAuthor;
import eu.dnetlib.doiboost.orcid.SparkConvertORCIDToOAF$;
import eu.dnetlib.doiboost.orcid.SparkPreprocessORCID$;
import java.nio.file.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u0017\t)R*\u00199qS:<wJU\"J\tR{w*\u0011$UKN$(BA\u0002\u0005\u0003\u0015y'oY5e\u0015\t)a!\u0001\u0005e_&\u0014wn\\:u\u0015\t9\u0001\"A\u0004e]\u0016$H.\u001b2\u000b\u0003%\t!!Z;\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0007Y><w-\u001a:\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000bMdg\r\u000e6\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0004M_\u001e<WM\u001d\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u000f1|wmZ3sA!9Q\u0005\u0001b\u0001\n\u00031\u0013AB7baB,'/F\u0001(!\tA\u0013'D\u0001*\u0015\tQ3&\u0001\u0005eCR\f'-\u001b8e\u0015\taS&A\u0004kC\u000e\\7o\u001c8\u000b\u00059z\u0013!\u00034bgR,'\u000f_7m\u0015\u0005\u0001\u0014aA2p[&\u0011!'\u000b\u0002\r\u001f\nTWm\u0019;NCB\u0004XM\u001d\u0005\u0007i\u0001\u0001\u000b\u0011B\u0014\u0002\u000f5\f\u0007\u000f]3sA!)a\u0007\u0001C\u0001o\u0005yA/Z:u\u000bb$(/Y2u\t\u0006$\u0018\rF\u00019!\ti\u0011(\u0003\u0002;\u001d\t!QK\\5uQ\t)D\b\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006\u0019\u0011\r]5\u000b\u0005\u0005\u0013\u0015a\u00026va&$XM\u001d\u0006\u0003\u0007z\tQA[;oSRL!!\u0012 \u0003\tQ+7\u000f\u001e\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u000fi\u0016\u001cHoT!G\u0007>tg/\u001a:u)\tA\u0014\nC\u0003K\r\u0002\u00071*A\u0004uKN$H)\u001b:\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015\u0001\u00024jY\u0016T!\u0001U)\u0002\u00079LwNC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Qk%\u0001\u0002)bi\"D#!\u0013,\u0011\u0005]SV\"\u0001-\u000b\u0005es\u0014AA5p\u0013\tY\u0006LA\u0004UK6\u0004H)\u001b:)\u0005\u0019c\u0004\"\u00020\u0001\t\u00039\u0014a\u0004;fgR,\u0005\u0010\u001e:bGR$\u0015\r^\u0019)\u0005uc\u0004")
public class MappingORCIDToOAFTest {
    private final Logger logger = LoggerFactory.getLogger(ORCIDToOAF$.MODULE$.getClass());
    private final ObjectMapper mapper = new ObjectMapper();

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Test
    public void testExtractData() {
        String json = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("dataOutput"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Assertions.assertNotNull((Object)json);
        Assertions.assertFalse((boolean)json.isEmpty());
        new StringOps(Predef$.MODULE$.augmentString(json)).lines().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String s) {
                Assertions.assertNotNull((Object)ORCIDToOAF$.MODULE$.extractValueFromInputString(s));
            }
        });
    }

    @Test
    public void testOAFConvert(@TempDir Path testDir) {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/doiboost/orcid/datasets").getPath();
        String targetPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/output/orcidPublication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)testDir).toString()}));
        String workingPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/wp/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)testDir).toString()}));
        SparkConf conf = new SparkConf();
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        SparkSession spark = SparkSession$.MODULE$.builder().appName(this.getClass().getSimpleName()).config(conf).getOrCreate();
        Encoder mapEncoderPubs = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Publication.class));
        SparkPreprocessORCID$.MODULE$.run(spark, sourcePath, workingPath);
        SparkConvertORCIDToOAF$.MODULE$.run(spark, workingPath, targetPath);
        ObjectMapper mapper = new ObjectMapper();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MappingORCIDToOAFTest.class.getClassLoader());
        public final class Eu_dnetlib_doiboost_orcid_MappingORCIDToOAFTest$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("eu.dnetlib.doiboost.orcid.ORCIDItem").asType().toTypeConstructor();
            }

            public Eu_dnetlib_doiboost_orcid_MappingORCIDToOAFTest$$typecreator4$1(MappingORCIDToOAFTest $outer) {
            }
        }
        long oA = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/orcidworksWithAuthor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath}))).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_doiboost_orcid_MappingORCIDToOAFTest$$typecreator4$1(this)))).count();
        Dataset p = spark.read().load(targetPath).as(mapEncoderPubs);
        Assertions.assertTrue((oA == p.count() ? 1 : 0) != 0);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString(p.first()));
        spark.close();
    }

    @Test
    public void testExtractDat1() {
        List aList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OrcidAuthor[]{new OrcidAuthor("0000-0002-4335-5309", (Option)new Some((Object)"Lucrecia"), (Option)new Some((Object)"Curto"), null, null, null), new OrcidAuthor("0000-0001-7501-3330", (Option)new Some((Object)"Emilio"), (Option)new Some((Object)"Malchiodi"), null, null, null), new OrcidAuthor("0000-0002-5490-9186", (Option)new Some((Object)"Sofia"), (Option)new Some((Object)"Noli Truant"), null, null, null)}));
        ORCIDItem orcid = new ORCIDItem("10.1042/BCJ20160876", aList);
        Publication oaf = ORCIDToOAF$.MODULE$.convertTOOAF(orcid);
        Predef$.MODULE$.assert(oaf.getPid().size() == 1);
        JavaConversions$.MODULE$.asScalaBuffer(oaf.getPid()).toList().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Predef$.MODULE$.assert(pid.getQualifier().getClassid().equals("doi"));
            }
        });
        JavaConversions$.MODULE$.asScalaBuffer(oaf.getPid()).toList().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty pid) {
                Predef$.MODULE$.assert(pid.getValue().equals("10.1042/BCJ20160876"));
            }
        });
    }
}

