/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid.xml;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.orcid.AuthorData;
import eu.dnetlib.dhp.schema.orcid.AuthorSummary;
import eu.dnetlib.dhp.schema.orcid.Work;
import eu.dnetlib.dhp.schema.orcid.WorkDetail;
import eu.dnetlib.doiboost.orcid.OrcidClientTest;
import eu.dnetlib.doiboost.orcid.model.WorkData;
import eu.dnetlib.doiboost.orcid.xml.XMLRecordParser;
import eu.dnetlib.doiboost.orcidnodoi.json.JsonWriter;
import eu.dnetlib.doiboost.orcidnodoi.xml.XMLRecordParserNoDoi;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class XMLRecordParserTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static Path testPath;

    @BeforeAll
    private static void setUp() throws IOException {
        testPath = Files.createTempDirectory(XMLRecordParserTest.class.getName(), new FileAttribute[0]);
    }

    @Test
    void testOrcidAuthorDataXMLParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("summary_0000-0001-6828-479X.xml"));
        AuthorData authorData = XMLRecordParser.VTDParseAuthorData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)authorData);
        Assertions.assertNotNull((Object)authorData.getName());
        System.out.println("name: " + authorData.getName());
        Assertions.assertNotNull((Object)authorData.getSurname());
        System.out.println("surname: " + authorData.getSurname());
        OrcidClientTest.logToFile(testPath, OBJECT_MAPPER.writeValueAsString((Object)authorData));
    }

    @Test
    void testOrcidXMLErrorRecordParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("summary_error.xml"));
        AuthorData authorData = XMLRecordParser.VTDParseAuthorData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)authorData);
        Assertions.assertNotNull((Object)authorData.getErrorCode());
        System.out.println("error: " + authorData.getErrorCode());
    }

    @Test
    void testOrcidWorkDataXMLParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("activity_work_0000-0003-2760-1191.xml"));
        WorkData workData = XMLRecordParser.VTDParseWorkData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)workData);
        Assertions.assertNotNull((Object)workData.getOid());
        System.out.println("oid: " + workData.getOid());
        Assertions.assertNull((Object)workData.getDoi());
    }

    @Test
    void testOrcidOtherNamesXMLParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("summary_0000-0001-5109-1000_othername.xml"));
        AuthorData authorData = XMLRecordParser.VTDParseAuthorData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)authorData);
        Assertions.assertNotNull((Object)authorData.getOtherNames());
        Assertions.assertEquals((Object)"Andrew C. Porteus", authorData.getOtherNames().get(0));
        String jsonData = JsonWriter.create((AuthorData)authorData);
        Assertions.assertNotNull((Object)jsonData);
    }

    @Test
    void testAuthorSummaryXMLParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record_0000-0001-5004-5918.xml"));
        AuthorSummary authorSummary = XMLRecordParser.VTDParseAuthorSummary((byte[])xml.getBytes());
        authorSummary.setBase64CompressData(ArgumentApplicationParser.compressArgument((String)xml));
        OrcidClientTest.logToFile(testPath, JsonWriter.create((Object)authorSummary));
    }

    @Test
    void testWorkDataXMLParser() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("activity_work_0000-0003-2760-1191.xml"));
        WorkDetail workDetail = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        Work work = new Work();
        work.setWorkDetail(workDetail);
        work.setBase64CompressData(ArgumentApplicationParser.compressArgument((String)xml));
        OrcidClientTest.logToFile(testPath, JsonWriter.create((Object)work));
    }
}

