/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.doiboost.orcidnodoi.oaf.PublicationToOaf;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PublicationToOafTest {
    private static final Logger logger = LoggerFactory.getLogger(PublicationToOafTest.class);

    PublicationToOafTest() {
    }

    @Test
    @Disabled
    void convertOafPublicationTest() throws Exception {
        String jsonPublication = IOUtils.toString((InputStream)PublicationToOafTest.class.getResourceAsStream("publication.json"));
        JsonElement j = new JsonParser().parse(jsonPublication);
        logger.info("json publication loaded: {}", (Object)j.toString());
        PublicationToOaf publicationToOaf = new PublicationToOaf();
        Publication oafPublication = (Publication)publicationToOaf.generatePublicationActionsFromDump(j.getAsJsonObject());
        Assertions.assertNotNull((Object)oafPublication.getId());
        Assertions.assertNotNull((Object)oafPublication.getOriginalId());
        Assertions.assertEquals((Object)"60153327", oafPublication.getOriginalId().get(0));
        logger.info("oafPublication.getId(): {}", (Object)oafPublication.getId());
        Assertions.assertEquals((Object)"Evaluation of a percutaneous optical fibre glucose sensor (FiberSense) across the glycemic range with rapid glucoseexcursions using the glucose clamp", (Object)((StructuredProperty)oafPublication.getTitle().get(0)).getValue());
        Assertions.assertNotNull((Object)oafPublication.getLastupdatetimestamp());
        Assertions.assertNotNull((Object)oafPublication.getDateofcollection());
        Assertions.assertNotNull((Object)oafPublication.getDateoftransformation());
        Assertions.assertEquals((int)7, (int)oafPublication.getAuthor().size());
        oafPublication.getAuthor().forEach(a -> {
            Assertions.assertNotNull((Object)a.getFullname());
            Assertions.assertNotNull((Object)a.getRank());
            logger.info("a.getFullname(): " + a.getFullname());
            if (a.getName() != null) {
                logger.info("a.getName(): " + a.getName());
            }
            if (a.getSurname() != null) {
                logger.info("a.getSurname(): " + a.getSurname());
            }
            logger.info("a.getRank(): " + a.getRank());
            if (a.getPid() != null) {
                logger.info("a.getPid(): " + ((StructuredProperty)a.getPid().get(0)).getValue());
            }
        });
        Assertions.assertNotNull((Object)oafPublication.getCollectedfrom());
        if (oafPublication.getSource() != null) {
            logger.info((String)((Field)oafPublication.getSource().get(0)).getValue());
        }
        if (oafPublication.getExternalReference() != null) {
            oafPublication.getExternalReference().forEach(e -> {
                Assertions.assertNotNull((Object)e.getRefidentifier());
                Assertions.assertEquals((Object)"dnet:pid_types", (Object)e.getQualifier().getSchemeid());
            });
        }
        Assertions.assertNotNull((Object)oafPublication.getInstance());
        oafPublication.getInstance().forEach(i -> {
            Assertions.assertNotNull((Object)i.getInstancetype().getClassid());
            logger.info("i.getInstancetype().getClassid(): {}", (Object)i.getInstancetype().getClassid());
            Assertions.assertNotNull((Object)i.getInstancetype().getClassname());
            logger.info("i.getInstancetype().getClassname(): {}", (Object)i.getInstancetype().getClassname());
        });
    }
}

