/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi.xml;

import com.google.common.collect.Lists;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import eu.dnetlib.dhp.parser.utility.VtdException;
import eu.dnetlib.dhp.schema.orcid.AuthorData;
import eu.dnetlib.dhp.schema.orcid.Contributor;
import eu.dnetlib.dhp.schema.orcid.WorkDetail;
import eu.dnetlib.doiboost.orcidnodoi.similarity.AuthorMatcher;
import eu.dnetlib.doiboost.orcidnodoi.xml.XMLRecordParserNoDoi;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrcidNoDoiTest {
    private static final Logger logger = LoggerFactory.getLogger(OrcidNoDoiTest.class);
    static String nameA = "Khairy";
    static String surnameA = "Abdel Dayem";
    static String orcidIdA = "0000-0003-2760-1191";

    OrcidNoDoiTest() {
    }

    @Test
    void readPublicationFieldsTest() throws IOException, XPathEvalException, XPathParseException, NavException, VtdException, ParseException {
        logger.info("running loadPublicationFieldsTest ....");
        String xml = IOUtils.toString((InputStream)OrcidNoDoiTest.class.getResourceAsStream("activity_work_0000-0002-2536-4498.xml"));
        if (xml == null) {
            logger.info("Resource not found");
        }
        WorkDetail workData = null;
        try {
            workData = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        }
        catch (Exception e2) {
            logger.error("parsing xml", (Throwable)e2);
        }
        Assertions.assertNotNull((Object)workData);
        Assertions.assertNotNull((Object)workData.getOid());
        logger.info("oid: " + workData.getOid());
        Assertions.assertNotNull((Object)workData.getTitles());
        logger.info("titles: ");
        workData.getTitles().forEach(t -> logger.info(t));
        logger.info("source: " + workData.getSourceName());
        logger.info("type: " + workData.getType());
        logger.info("urls: ");
        workData.getUrls().forEach(u -> logger.info(u));
        logger.info("publication date: ");
        workData.getPublicationDates().forEach(d -> logger.info(d.getYear() + " - " + d.getMonth() + " - " + d.getDay()));
        logger.info("external id: ");
        workData.getExtIds().removeIf(e -> e.getRelationShip() != null && !e.getRelationShip().equals("self"));
        workData.getExtIds().forEach(e -> logger.info(e.getType() + " - " + e.getValue() + " - " + e.getRelationShip()));
        logger.info("contributors: ");
        workData.getContributors().forEach(c -> logger.info(c.getName() + " - " + c.getRole() + " - " + c.getSequence()));
    }

    @Test
    void authorDoubleMatchTest() throws Exception {
        logger.info("running authorSimpleMatchTest ....");
        String orcidWork = "activity_work_0000-0003-2760-1191-similarity.xml";
        AuthorData author = new AuthorData();
        author.setName(nameA);
        author.setSurname(surnameA);
        author.setOid(orcidIdA);
        String xml = IOUtils.toString((InputStream)OrcidNoDoiTest.class.getResourceAsStream(orcidWork));
        WorkDetail workData = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)workData);
        Contributor a = (Contributor)workData.getContributors().get(0);
        Assertions.assertEquals((Object)"Abdel-Dayem K", (Object)a.getCreditName());
        AuthorMatcher.match((AuthorData)author, (List)workData.getContributors());
        Assertions.assertEquals((int)6, (int)workData.getContributors().size());
    }

    @Test
    void readContributorsTest() throws IOException, XPathEvalException, XPathParseException, NavException, VtdException, ParseException {
        logger.info("running loadPublicationFieldsTest ....");
        String xml = IOUtils.toString((InputStream)OrcidNoDoiTest.class.getResourceAsStream("activity_work_0000-0003-2760-1191_contributors.xml"));
        WorkDetail workData = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        Assertions.assertNotNull((Object)workData.getContributors());
        Assertions.assertEquals((int)5, (int)workData.getContributors().size());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(0)).getCreditName()));
        Assertions.assertEquals((Object)"seq0", (Object)((Contributor)workData.getContributors().get(0)).getSequence());
        Assertions.assertEquals((Object)"role0", (Object)((Contributor)workData.getContributors().get(0)).getRole());
        Assertions.assertEquals((Object)"creditname1", (Object)((Contributor)workData.getContributors().get(1)).getCreditName());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(1)).getSequence()));
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(1)).getRole()));
        Assertions.assertEquals((Object)"creditname2", (Object)((Contributor)workData.getContributors().get(2)).getCreditName());
        Assertions.assertEquals((Object)"seq2", (Object)((Contributor)workData.getContributors().get(2)).getSequence());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(2)).getRole()));
        Assertions.assertEquals((Object)"creditname3", (Object)((Contributor)workData.getContributors().get(3)).getCreditName());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(3)).getSequence()));
        Assertions.assertEquals((Object)"role3", (Object)((Contributor)workData.getContributors().get(3)).getRole());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)workData.getContributors().get(4)).getCreditName()));
        Assertions.assertEquals((Object)"seq4", (Object)((Contributor)workData.getContributors().get(4)).getSequence());
        Assertions.assertEquals((Object)"role4", (Object)((Contributor)workData.getContributors().get(4)).getRole());
    }

    @Test
    void authorSimpleMatchTest() throws Exception {
        String orcidWork = "activity_work_0000-0002-5982-8983.xml";
        AuthorData author = new AuthorData();
        author.setName("Parkhouse");
        author.setSurname("H.");
        author.setOid("0000-0002-5982-8983");
        String xml = IOUtils.toString((InputStream)OrcidNoDoiTest.class.getResourceAsStream(orcidWork));
        if (xml == null) {
            logger.info("Resource not found");
        }
        WorkDetail workData = null;
        try {
            workData = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        }
        catch (Exception e) {
            logger.error("parsing xml", (Throwable)e);
        }
        Assertions.assertNotNull((Object)workData);
        Contributor a = (Contributor)workData.getContributors().get(0);
        Assertions.assertEquals((Object)"Parkhouse, H.", (Object)a.getCreditName());
        AuthorMatcher.match((AuthorData)author, (List)workData.getContributors());
        Assertions.assertEquals((int)2, (int)workData.getContributors().size());
        Contributor c = (Contributor)workData.getContributors().get(0);
        Assertions.assertEquals((Object)"0000-0002-5982-8983", (Object)c.getOid());
        Assertions.assertEquals((Object)"Parkhouse", (Object)c.getName());
        Assertions.assertEquals((Object)"H.", (Object)c.getSurname());
        Assertions.assertEquals((Object)"Parkhouse, H.", (Object)c.getCreditName());
    }

    @Test
    void match() {
        AuthorData author = new AuthorData();
        author.setName("Joe");
        author.setSurname("Dodge");
        author.setOid("0000-1111-2222-3333");
        Contributor contributor = new Contributor();
        contributor.setCreditName("Joe Dodge");
        List<Contributor> contributors = Arrays.asList(contributor);
        int matchCounter = 0;
        List<Integer> matchCounters = Arrays.asList(matchCounter);
        contributors.stream().filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).forEach(c -> {
            if (AuthorMatcher.simpleMatch((String)c.getCreditName(), (String)author.getName()) || AuthorMatcher.simpleMatch((String)c.getCreditName(), (String)author.getSurname()) || AuthorMatcher.simpleMatchOnOtherNames((String)c.getCreditName(), (List)author.getOtherNames())) {
                matchCounters.set(0, (Integer)matchCounters.get(0) + 1);
                c.setSimpleMatch(true);
            }
        });
        Assertions.assertEquals((int)1, (Integer)matchCounters.get(0));
        AuthorMatcher.updateAuthorsSimpleMatch(contributors, (AuthorData)author);
        Assertions.assertEquals((Object)"Joe", (Object)contributors.get(0).getName());
        Assertions.assertEquals((Object)"Dodge", (Object)contributors.get(0).getSurname());
        Assertions.assertEquals((Object)"Joe Dodge", (Object)contributors.get(0).getCreditName());
        Assertions.assertEquals((Object)"0000-1111-2222-3333", (Object)contributors.get(0).getOid());
        AuthorData authorX = new AuthorData();
        authorX.setName(nameA);
        authorX.setSurname(surnameA);
        authorX.setOid(orcidIdA);
        Contributor contributorA = new Contributor();
        contributorA.setCreditName("Abdel-Dayem Khai");
        Contributor contributorB = new Contributor();
        contributorB.setCreditName("Abdel-Dayem Fake");
        ArrayList<Contributor> contributorList = new ArrayList<Contributor>();
        contributorList.add(contributorA);
        contributorList.add(contributorB);
        int matchCounter2 = 0;
        List<Integer> matchCounters2 = Arrays.asList(matchCounter2);
        contributorList.stream().filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).forEach(c -> {
            if (AuthorMatcher.simpleMatch((String)c.getCreditName(), (String)authorX.getName()) || AuthorMatcher.simpleMatch((String)c.getCreditName(), (String)authorX.getSurname()) || AuthorMatcher.simpleMatchOnOtherNames((String)c.getCreditName(), (List)author.getOtherNames())) {
                int currentCounter = (Integer)matchCounters2.get(0);
                matchCounters2.set(0, ++currentCounter);
                c.setSimpleMatch(true);
            }
        });
        Assertions.assertEquals((int)2, (Integer)matchCounters2.get(0));
        Assertions.assertTrue((boolean)((Contributor)contributorList.get(0)).isSimpleMatch());
        Assertions.assertTrue((boolean)((Contributor)contributorList.get(1)).isSimpleMatch());
        Optional<Contributor> optCon = contributorList.stream().filter(c -> c.isSimpleMatch()).filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).map(c -> {
            c.setScore(AuthorMatcher.bestMatch((String)authorX.getName(), (String)authorX.getSurname(), (String)c.getCreditName()));
            return c;
        }).filter(c -> c.getScore() >= AuthorMatcher.THRESHOLD).max(Comparator.comparing(c -> c.getScore()));
        Assertions.assertTrue((boolean)optCon.isPresent());
        Contributor bestMatchContributor = optCon.get();
        bestMatchContributor.setBestMatch(true);
        Assertions.assertTrue((boolean)bestMatchContributor.getCreditName().equals("Abdel-Dayem Khai"));
        Assertions.assertTrue((boolean)((Contributor)contributorList.get(0)).isBestMatch());
        Assertions.assertTrue((!((Contributor)contributorList.get(1)).isBestMatch() ? 1 : 0) != 0);
        AuthorMatcher.updateAuthorsSimilarityMatch(contributorList, (AuthorData)authorX);
        Assertions.assertEquals((Object)nameA, (Object)((Contributor)contributorList.get(0)).getName());
        Assertions.assertEquals((Object)surnameA, (Object)((Contributor)contributorList.get(0)).getSurname());
        Assertions.assertEquals((Object)"Abdel-Dayem Khai", (Object)((Contributor)contributorList.get(0)).getCreditName());
        Assertions.assertEquals((Object)orcidIdA, (Object)((Contributor)contributorList.get(0)).getOid());
        Assertions.assertTrue((boolean)StringUtils.isBlank((CharSequence)((Contributor)contributorList.get(1)).getOid()));
    }

    @Test
    void authorBestMatchTest() throws Exception {
        String name = "Khairy";
        String surname = "Abdel Dayem";
        String orcidWork = "activity_work_0000-0003-2760-1191.xml";
        AuthorData author = new AuthorData();
        author.setName(name);
        author.setSurname(surname);
        author.setOid(orcidIdA);
        String xml = IOUtils.toString((InputStream)OrcidNoDoiTest.class.getResourceAsStream(orcidWork));
        if (xml == null) {
            logger.info("Resource not found");
        }
        WorkDetail workData = null;
        try {
            workData = XMLRecordParserNoDoi.VTDParseWorkData((byte[])xml.getBytes());
        }
        catch (Exception e) {
            logger.error("parsing xml", (Throwable)e);
        }
        AuthorMatcher.match((AuthorData)author, (List)workData.getContributors());
        Assertions.assertEquals((int)5, (int)workData.getContributors().size());
        List c = workData.getContributors();
        Assertions.assertEquals((Object)name, (Object)((Contributor)c.get(0)).getName());
        Assertions.assertEquals((Object)surname, (Object)((Contributor)c.get(0)).getSurname());
        Assertions.assertEquals((Object)"Khair Abde Daye", (Object)((Contributor)c.get(0)).getCreditName());
        Assertions.assertEquals((Object)orcidIdA, (Object)((Contributor)c.get(0)).getOid());
    }

    @Test
    void otherNamesMatchTest() throws VtdException, ParseException, IOException, XPathEvalException, NavException, XPathParseException {
        AuthorData author = new AuthorData();
        author.setName("Joe");
        author.setSurname("Dodge");
        author.setOid("0000-1111-2222-3333");
        String otherName1 = "Joe Dr. Dodge";
        String otherName2 = "XY";
        ArrayList others = Lists.newArrayList();
        others.add(otherName1);
        others.add(otherName2);
        author.setOtherNames((List)others);
        Contributor contributor = new Contributor();
        contributor.setCreditName("XY");
        List<Contributor> contributors = Arrays.asList(contributor);
        AuthorMatcher.match((AuthorData)author, contributors);
        Assertions.assertEquals((Object)"Joe", (Object)contributors.get(0).getName());
        Assertions.assertEquals((Object)"Dodge", (Object)contributors.get(0).getSurname());
        Assertions.assertEquals((Object)"0000-1111-2222-3333", (Object)contributors.get(0).getOid());
    }
}

