/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.crossref;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.doiboost.crossref.ESClient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class CrossrefImporter {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(CrossrefImporter.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/import_from_es.json"))));
        parser.parseArgument(args);
        String namenode = parser.get("namenode");
        System.out.println("namenode: " + namenode);
        Path targetPath = new Path(parser.get("targetPath"));
        System.out.println("targetPath: " + targetPath);
        Long timestamp = Optional.ofNullable(parser.get("timestamp")).map(s -> {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }).orElse(-1L);
        System.out.println("timestamp: " + timestamp);
        String esServer = parser.get("esServer");
        System.out.println("esServer: " + esServer);
        String esIndex = parser.get("esIndex");
        System.out.println("esIndex: " + esIndex);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", namenode);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        ESClient client = new ESClient(esServer, esIndex, timestamp);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)targetPath), SequenceFile.Writer.keyClass(IntWritable.class), SequenceFile.Writer.valueClass(Text.class)});){
            int i = 0;
            long start = System.currentTimeMillis();
            long end = 0L;
            IntWritable key = new IntWritable(i);
            Text value = new Text();
            while (client.hasNext()) {
                key.set(i++);
                value.set(client.next());
                writer.append((Writable)key, (Writable)value);
                if (i % 100000 != 0) continue;
                end = System.currentTimeMillis();
                float time = (float)(end - start) / 1000.0f;
                System.out.println(String.format("Imported %s records last 100000 imported in %s seconds", i, Float.valueOf(time)));
                start = System.currentTimeMillis();
            }
        }
    }

    public static String decompressBlob(String blob) {
        try {
            byte[] byteArray = Base64.decodeBase64((byte[])blob.getBytes());
            Inflater decompresser = new Inflater();
            decompresser.setInput(byteArray);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(byteArray.length);
            byte[] buffer = new byte[8192];
            while (!decompresser.finished()) {
                int size = decompresser.inflate(buffer);
                bos.write(buffer, 0, size);
            }
            decompresser.end();
            return bos.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException("Wrong record:" + blob, e);
        }
    }
}

