/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.crossref;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.mortbay.log.Log;

public class ExtractCrossrefRecords {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ExtractCrossrefRecords.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/crossref_dump_reader/crossref_dump_reader.json")));
        parser.parseArgument(args);
        String hdfsServerUri = parser.get("hdfsServerUri");
        String workingPath = hdfsServerUri.concat(parser.get("workingPath"));
        String outputPath = parser.get("outputPath");
        String crossrefFileNameTarGz = parser.get("crossrefFileNameTarGz");
        Path hdfsreadpath = new Path(workingPath.concat("/").concat(crossrefFileNameTarGz));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", workingPath);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        FileSystem fs = FileSystem.get((URI)URI.create(workingPath), (Configuration)conf);
        FSDataInputStream crossrefFileStream = fs.open(hdfsreadpath);
        try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)crossrefFileStream));){
            TarArchiveEntry entry = null;
            while ((entry = tais.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                FSDataOutputStream out = fs.create(new Path(outputPath.concat(entry.getName()).concat(".gz")));
                Throwable throwable = null;
                try {
                    GZIPOutputStream gzipOs = new GZIPOutputStream(new BufferedOutputStream((OutputStream)out));
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)tais, (OutputStream)gzipOs);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (gzipOs == null) continue;
                        if (throwable2 != null) {
                            try {
                                gzipOs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        gzipOs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        Log.info((String)"Crossref dump reading completed");
    }
}

