/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.doiboost.orcid.model.DownloadedRecordData;
import eu.dnetlib.doiboost.orcid.util.DownloadsReport;
import eu.dnetlib.doiboost.orcid.util.HDFSUtil;
import eu.dnetlib.doiboost.orcid.util.MultiAttemptsHttpConnector;
import eu.dnetlib.doiboost.orcid.xml.XMLRecordParser;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkDownloadOrcidWorks {
    static Logger logger = LoggerFactory.getLogger(SparkDownloadOrcidWorks.class);
    public static final String LAMBDA_FILE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter LAMBDA_FILE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String ORCID_XML_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final DateTimeFormatter ORCID_XML_DATETIMEFORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkDownloadOrcidWorks.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/download_orcid_data.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        logger.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String workingPath = parser.get("workingPath");
        logger.info("workingPath: {}", (Object)workingPath);
        String outputPath = parser.get("outputPath");
        String token = parser.get("token");
        String hdfsServerUri = parser.get("hdfsServerUri");
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            String lastUpdateValue = HDFSUtil.readFromTextFile(hdfsServerUri, workingPath, "last_update.txt");
            logger.info("lastUpdateValue: ", (Object)lastUpdateValue);
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
            LongAccumulator updatedAuthorsAcc = spark.sparkContext().longAccumulator("updated_authors");
            LongAccumulator parsedAuthorsAcc = spark.sparkContext().longAccumulator("parsed_authors");
            LongAccumulator parsedWorksAcc = spark.sparkContext().longAccumulator("parsed_works");
            LongAccumulator modifiedWorksAcc = spark.sparkContext().longAccumulator("modified_works");
            LongAccumulator maxModifiedWorksLimitAcc = spark.sparkContext().longAccumulator("max_modified_works_limit");
            LongAccumulator errorCodeFoundAcc = spark.sparkContext().longAccumulator("error_code_found");
            LongAccumulator errorLoadingJsonFoundAcc = spark.sparkContext().longAccumulator("error_loading_json_found");
            LongAccumulator errorLoadingXMLFoundAcc = spark.sparkContext().longAccumulator("error_loading_xml_found");
            LongAccumulator errorParsingXMLFoundAcc = spark.sparkContext().longAccumulator("error_parsing_xml_found");
            LongAccumulator downloadedRecordsAcc = spark.sparkContext().longAccumulator("downloaded_records");
            LongAccumulator errorsAcc = spark.sparkContext().longAccumulator("errors");
            JavaPairRDD updatedAuthorsRDD = sc.sequenceFile(workingPath + "downloads/updated_authors/*", Text.class, Text.class);
            updatedAuthorsAcc.setValue(updatedAuthorsRDD.count());
            FlatMapFunction & Serializable retrieveWorkUrlFunction = (FlatMapFunction & Serializable)data -> {
                String orcidId = ((Text)data._1()).toString();
                String jsonData = ((Text)data._2()).toString();
                ArrayList workIds = new ArrayList();
                Map<String, String> workIdLastModifiedDate = new HashMap<String, String>();
                JsonElement jElement = new JsonParser().parse(jsonData);
                String statusCode = SparkDownloadOrcidWorks.getJsonValue(jElement, "statusCode");
                if (statusCode.equals("200")) {
                    String compressedData = SparkDownloadOrcidWorks.getJsonValue(jElement, "compressedData");
                    if (StringUtils.isEmpty((CharSequence)compressedData)) {
                        errorLoadingJsonFoundAcc.add(1L);
                    } else {
                        String authorSummary = ArgumentApplicationParser.decompressValue((String)compressedData);
                        if (StringUtils.isEmpty((CharSequence)authorSummary)) {
                            errorLoadingXMLFoundAcc.add(1L);
                        } else {
                            try {
                                workIdLastModifiedDate = XMLRecordParser.retrieveWorkIdLastModifiedDate(authorSummary.getBytes());
                            }
                            catch (Exception e) {
                                logger.error("parsing " + orcidId + " [" + jsonData + "]", (Throwable)e);
                                errorParsingXMLFoundAcc.add(1L);
                            }
                        }
                    }
                } else {
                    errorCodeFoundAcc.add(1L);
                }
                parsedAuthorsAcc.add(1L);
                workIdLastModifiedDate.forEach((k, v) -> {
                    parsedWorksAcc.add(1L);
                    if (SparkDownloadOrcidWorks.isModified(orcidId, v, lastUpdateValue)) {
                        modifiedWorksAcc.add(1L);
                        workIds.add(orcidId.concat("/work/").concat((String)k));
                    }
                });
                if (workIdLastModifiedDate.size() > 50) {
                    maxModifiedWorksLimitAcc.add(1L);
                }
                return workIds.iterator();
            };
            Function & Serializable downloadWorkFunction = (Function & Serializable)data -> {
                String relativeWorkUrl = data;
                String orcidId = relativeWorkUrl.split("/")[0];
                DownloadedRecordData downloaded = new DownloadedRecordData();
                downloaded.setOrcidId(orcidId);
                downloaded.setLastModifiedDate(lastUpdateValue);
                HttpClientParams clientParams = new HttpClientParams();
                MultiAttemptsHttpConnector httpConnector = new MultiAttemptsHttpConnector(clientParams);
                httpConnector.setAuthMethod("BEARER");
                httpConnector.setAcceptHeaderValue("application/vnd.orcid+xml");
                httpConnector.setAuthToken(token);
                String apiUrl = "https://api.orcid.org/v3.0/" + relativeWorkUrl;
                DownloadsReport report = new DownloadsReport();
                long startReq = System.currentTimeMillis();
                boolean downloadCompleted = false;
                String record = "";
                try {
                    record = httpConnector.getInputSource(apiUrl, report);
                    downloadCompleted = true;
                }
                catch (CollectorException ce) {
                    if (!report.isEmpty()) {
                        int errCode = (Integer)report.keySet().stream().findFirst().get();
                        report.forEach((k, v) -> logger.error(k + " " + v));
                        downloaded.setStatusCode(errCode);
                    } else {
                        downloaded.setStatusCode(-4);
                    }
                    errorsAcc.add(1L);
                }
                long endReq = System.currentTimeMillis();
                long reqTime = endReq - startReq;
                if (reqTime < 1000L) {
                    Thread.sleep(1000L - reqTime);
                }
                if (downloadCompleted) {
                    downloaded.setStatusCode(200);
                    downloadedRecordsAcc.add(1L);
                    downloaded.setCompressedData(ArgumentApplicationParser.compressArgument((String)record));
                }
                return downloaded.toTuple2();
            };
            updatedAuthorsRDD.flatMap((FlatMapFunction)retrieveWorkUrlFunction).repartition(100).map((Function)downloadWorkFunction).mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)new Text((String)t._1()), (Object)new Text((String)t._2()))).saveAsTextFile(workingPath.concat(outputPath), GzipCodec.class);
            logger.info("updatedAuthorsAcc: {}", (Object)updatedAuthorsAcc.value());
            logger.info("parsedAuthorsAcc: {}", (Object)parsedAuthorsAcc.value());
            logger.info("parsedWorksAcc: {}", (Object)parsedWorksAcc.value());
            logger.info("modifiedWorksAcc: {}", (Object)modifiedWorksAcc.value());
            logger.info("maxModifiedWorksLimitAcc: {}", (Object)maxModifiedWorksLimitAcc.value());
            logger.info("errorCodeFoundAcc: {}", (Object)errorCodeFoundAcc.value());
            logger.info("errorLoadingJsonFoundAcc: {}", (Object)errorLoadingJsonFoundAcc.value());
            logger.info("errorLoadingXMLFoundAcc: {}", (Object)errorLoadingXMLFoundAcc.value());
            logger.info("errorParsingXMLFoundAcc: {}", (Object)errorParsingXMLFoundAcc.value());
            logger.info("downloadedRecordsAcc: {}", (Object)downloadedRecordsAcc.value());
            logger.info("errorsAcc: {}", (Object)errorsAcc.value());
        });
    }

    public static boolean isModified(String orcidId, String modifiedDateValue, String lastUpdateValue) {
        LocalDate modifiedDate = null;
        LocalDate lastUpdate = null;
        try {
            modifiedDate = LocalDate.parse(modifiedDateValue, ORCID_XML_DATETIMEFORMATTER);
            if (lastUpdateValue.length() != 19) {
                lastUpdateValue = lastUpdateValue.substring(0, 19);
            }
            lastUpdate = LocalDate.parse(lastUpdateValue, LAMBDA_FILE_DATE_FORMATTER);
        }
        catch (Exception e) {
            logger.info("[" + orcidId + "] Parsing date: ", (Object)e.getMessage());
            throw new RuntimeException("[" + orcidId + "] Parsing date: " + e.getMessage());
        }
        return modifiedDate.isAfter(lastUpdate);
    }

    private static String getJsonValue(JsonElement jElement, String property) {
        if (jElement.getAsJsonObject().has(property)) {
            JsonElement name = null;
            name = jElement.getAsJsonObject().get(property);
            if (name != null && !name.isJsonNull()) {
                return name.getAsString();
            }
        }
        return "";
    }
}

