/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid.util;

import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.doiboost.orcid.util.DownloadsReport;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAttemptsHttpConnector {
    private static final Logger log = LoggerFactory.getLogger(MultiAttemptsHttpConnector.class);
    private HttpClientParams clientParams;
    private String responseType = null;
    private static final String userAgent = "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)";
    private String authToken = "";
    private String acceptHeaderValue = "";
    private String authMethod = "";
    public static final String BEARER = "BEARER";

    public MultiAttemptsHttpConnector() {
        this(new HttpClientParams());
    }

    public MultiAttemptsHttpConnector(HttpClientParams clientParams) {
        this.clientParams = clientParams;
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    public String getInputSource(String requestUrl, DownloadsReport report) throws CollectorException {
        return this.attemptDownloadAsString(requestUrl, 1, report);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String attemptDownloadAsString(String requestUrl, int retryNumber, DownloadsReport report) throws CollectorException {
        try (InputStream s = this.attemptDownload(requestUrl, retryNumber, report);){
            String string = IOUtils.toString((InputStream)s);
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CollectorException((Throwable)e);
        }
    }

    private InputStream attemptDownload(String requestUrl, int retryNumber, DownloadsReport report) throws CollectorException, IOException {
        if (retryNumber > this.getClientParams().getMaxNumberOfRetry()) {
            String msg = String.format("Max number of retries (%s/%s) exceeded, failing.", retryNumber, this.getClientParams().getMaxNumberOfRetry());
            log.error(msg);
            throw new CollectorException(msg);
        }
        log.info("Request attempt {} [{}]", (Object)retryNumber, (Object)requestUrl);
        InputStream input = null;
        try {
            if (this.getClientParams().getRequestDelay() > 0) {
                this.backoffAndSleep(this.getClientParams().getRequestDelay());
            }
            HttpURLConnection urlConn = (HttpURLConnection)new URL(requestUrl).openConnection();
            urlConn.setInstanceFollowRedirects(false);
            urlConn.setReadTimeout(this.getClientParams().getReadTimeOut() * 1000);
            urlConn.setConnectTimeout(this.getClientParams().getConnectTimeOut() * 1000);
            urlConn.addRequestProperty("User-Agent", userAgent);
            if (!this.getAcceptHeaderValue().isEmpty()) {
                urlConn.addRequestProperty("Accept", this.getAcceptHeaderValue());
            }
            if (!this.getAuthToken().isEmpty() && this.getAuthMethod().equals(BEARER)) {
                urlConn.addRequestProperty("Authorization", String.format("Bearer %s", this.getAuthToken()));
            }
            if (log.isDebugEnabled()) {
                this.logHeaderFields(urlConn);
            }
            int retryAfter = this.obtainRetryAfter(urlConn.getHeaderFields());
            if (this.is2xx(urlConn.getResponseCode())) {
                input = urlConn.getInputStream();
                this.responseType = urlConn.getContentType();
                return input;
            }
            if (this.is3xx(urlConn.getResponseCode())) {
                String newUrl = this.obtainNewLocation(urlConn.getHeaderFields());
                log.info("The requested url has been moved to {}", (Object)newUrl);
                report.put(urlConn.getResponseCode(), String.format("Moved to: %s", newUrl));
                urlConn.disconnect();
                if (retryAfter > 0) {
                    this.backoffAndSleep(retryAfter);
                }
                return this.attemptDownload(newUrl, retryNumber + 1, report);
            }
            if (this.is4xx(urlConn.getResponseCode()) || this.is5xx(urlConn.getResponseCode())) {
                switch (urlConn.getResponseCode()) {
                    case 404: 
                    case 502: 
                    case 503: 
                    case 504: {
                        if (retryAfter > 0) {
                            log.warn("{} - waiting and repeating request after suggested retry-after {} sec.", (Object)requestUrl, (Object)retryAfter);
                            this.backoffAndSleep(retryAfter * 1000);
                        } else {
                            log.warn("{} - waiting and repeating request after default delay of {} sec.", (Object)requestUrl, (Object)this.getClientParams().getRetryDelay());
                            this.backoffAndSleep(retryNumber * this.getClientParams().getRetryDelay() * 1000);
                        }
                        report.put(urlConn.getResponseCode(), requestUrl);
                        urlConn.disconnect();
                        return this.attemptDownload(requestUrl, retryNumber + 1, report);
                    }
                }
                report.put(urlConn.getResponseCode(), String.format("%s Error: %s", requestUrl, urlConn.getResponseMessage()));
                throw new CollectorException(urlConn.getResponseCode() + " error " + report);
            }
            throw new CollectorException(String.format("Unexpected status code: %s errors: %s", urlConn.getResponseCode(), DHPUtils.MAPPER.writeValueAsString((Object)report)));
        }
        catch (MalformedURLException | UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
            report.put(-2, e.getMessage());
            throw new CollectorException(e.getMessage(), (Throwable)e);
        }
        catch (SocketException | SocketTimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
            report.put(-3, e.getMessage());
            this.backoffAndSleep(this.getClientParams().getRetryDelay() * retryNumber * 1000);
            return this.attemptDownload(requestUrl, retryNumber + 1, report);
        }
    }

    private void logHeaderFields(HttpURLConnection urlConn) throws IOException {
        log.debug("StatusCode: {}", (Object)urlConn.getResponseMessage());
        for (Map.Entry<String, List<String>> e : urlConn.getHeaderFields().entrySet()) {
            if (e.getKey() == null) continue;
            for (String v : e.getValue()) {
                log.debug("  key: {} - value: {}", (Object)e.getKey(), (Object)v);
            }
        }
    }

    private void backoffAndSleep(int sleepTimeMs) throws CollectorException {
        log.info("I'm going to sleep for {}ms", (Object)sleepTimeMs);
        try {
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CollectorException((Throwable)e);
        }
    }

    private int obtainRetryAfter(Map<String, List<String>> headerMap) {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.equalsIgnoreCase("Retry-After") || headerMap.get(key).isEmpty() || !NumberUtils.isCreatable((String)headerMap.get(key).get(0))) continue;
            return Integer.parseInt(headerMap.get(key).get(0)) + 10;
        }
        return -1;
    }

    private String obtainNewLocation(Map<String, List<String>> headerMap) throws CollectorException {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.equalsIgnoreCase("Location") || headerMap.get(key).size() <= 0) continue;
            return headerMap.get(key).get(0);
        }
        throw new CollectorException("The requested url has been MOVED, but 'location' param is MISSING");
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    private boolean is4xx(int statusCode) {
        return statusCode >= 400 && statusCode <= 499;
    }

    private boolean is3xx(int statusCode) {
        return statusCode >= 300 && statusCode <= 399;
    }

    private boolean is5xx(int statusCode) {
        return statusCode >= 500 && statusCode <= 599;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    private String getAuthToken() {
        return this.authToken;
    }

    public String getAcceptHeaderValue() {
        return this.acceptHeaderValue;
    }

    public void setAcceptHeaderValue(String acceptHeaderValue) {
        this.acceptHeaderValue = acceptHeaderValue;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }
}

