/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi.oaf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.doiboost.orcidnodoi.util.DumpToActionsUtility;
import eu.dnetlib.doiboost.orcidnodoi.util.Pair;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationToOaf
implements Serializable {
    static Logger logger = LoggerFactory.getLogger(PublicationToOaf.class);
    public static final String orcidPREFIX = "orcid_______";
    public static final String OPENAIRE_PREFIX = "openaire____";
    public static final String SEPARATOR = "::";
    public static final String DEACTIVATED_NAME = "Given Names Deactivated";
    public static final String DEACTIVATED_SURNAME = "Family Name Deactivated";
    private String dateOfCollection = "";
    private final LongAccumulator parsedPublications;
    private final LongAccumulator enrichedPublications;
    private final LongAccumulator errorsInvalidTitle;
    private final LongAccumulator errorsNotFoundAuthors;
    private final LongAccumulator errorsInvalidType;
    private final LongAccumulator otherTypeFound;
    private final LongAccumulator deactivatedAcc;
    private final LongAccumulator titleNotProvidedAcc;
    private final LongAccumulator noUrlAcc;
    private static final Map<String, Pair<String, String>> externalIds = new HashMap<String, Pair<String, String>>(){
        {
            this.put("ark".toLowerCase(), new Pair<String, String>("ark", "ark"));
            this.put("arxiv".toLowerCase(), new Pair<String, String>("arXiv", "arXiv"));
            this.put("pmc".toLowerCase(), new Pair<String, String>("pmc", "PubMed Central ID"));
            this.put("pmid".toLowerCase(), new Pair<String, String>("pmid", "PubMed ID"));
            this.put("source-work-id".toLowerCase(), new Pair<String, String>("orcidworkid", "orcid workid"));
            this.put("urn".toLowerCase(), new Pair<String, String>("urn", "urn"));
        }
    };
    static Map<String, Map<String, String>> typologiesMapping;

    public PublicationToOaf(LongAccumulator parsedPublications, LongAccumulator enrichedPublications, LongAccumulator errorsInvalidTitle, LongAccumulator errorsNotFoundAuthors, LongAccumulator errorsInvalidType, LongAccumulator otherTypeFound, LongAccumulator deactivatedAcc, LongAccumulator titleNotProvidedAcc, LongAccumulator noUrlAcc, String dateOfCollection) {
        this.parsedPublications = parsedPublications;
        this.enrichedPublications = enrichedPublications;
        this.errorsInvalidTitle = errorsInvalidTitle;
        this.errorsNotFoundAuthors = errorsNotFoundAuthors;
        this.errorsInvalidType = errorsInvalidType;
        this.otherTypeFound = otherTypeFound;
        this.deactivatedAcc = deactivatedAcc;
        this.titleNotProvidedAcc = titleNotProvidedAcc;
        this.noUrlAcc = noUrlAcc;
        this.dateOfCollection = dateOfCollection;
    }

    public PublicationToOaf() {
        this.parsedPublications = null;
        this.enrichedPublications = null;
        this.errorsInvalidTitle = null;
        this.errorsNotFoundAuthors = null;
        this.errorsInvalidType = null;
        this.otherTypeFound = null;
        this.deactivatedAcc = null;
        this.titleNotProvidedAcc = null;
        this.noUrlAcc = null;
        this.dateOfCollection = null;
    }

    public Oaf generatePublicationActionsFromJson(String json) {
        if (this.parsedPublications != null) {
            this.parsedPublications.add(1L);
        }
        JsonElement jElement = new JsonParser().parse(json);
        JsonObject jObject = jElement.getAsJsonObject();
        return this.generatePublicationActionsFromDump(jObject);
    }

    public Oaf generatePublicationActionsFromDump(JsonObject rootElement) {
        Instance instance;
        String typeValue;
        List<String> titles;
        if (!this.isValid(rootElement)) {
            return null;
        }
        Publication publication = new Publication();
        DataInfo dataInfo = new DataInfo();
        dataInfo.setDeletedbyinference(Boolean.valueOf(false));
        dataInfo.setInferred(Boolean.valueOf(false));
        dataInfo.setTrust("0.9");
        dataInfo.setProvenanceaction(this.mapQualifier("sysimport:actionset:orcidworks-no-doi", "sysimport:actionset:orcidworks-no-doi", "dnet:provenanceActions", "dnet:provenanceActions"));
        publication.setDataInfo(dataInfo);
        publication.setLastupdatetimestamp(Long.valueOf(new Date().getTime()));
        publication.setDateofcollection(this.dateOfCollection);
        publication.setDateoftransformation(DumpToActionsUtility.now_ISO8601());
        externalIds.keySet().stream().forEach(jsonExtId -> {
            String classid = externalIds.get(jsonExtId.toLowerCase()).getKey();
            String classname = externalIds.get(jsonExtId.toLowerCase()).getValue();
            String extId = DumpToActionsUtility.getStringValue(rootElement, jsonExtId);
            if (StringUtils.isNotBlank((CharSequence)extId)) {
                publication.getExternalReference().add(this.convertExtRef(extId, classid, classname, "dnet:pid_types", "dnet:pid_types"));
            }
        });
        String source = DumpToActionsUtility.getStringValue(rootElement, "sourceName");
        if (StringUtils.isNotBlank((CharSequence)source)) {
            Field<String> sourceField = this.mapStringField(source, null);
            if (sourceField == null) {
                publication.setSource(null);
            } else {
                publication.setSource(Arrays.asList(sourceField));
            }
        }
        if ((titles = this.createRepeatedField(rootElement, "titles")) == null || titles.isEmpty()) {
            if (this.errorsInvalidTitle != null) {
                this.errorsInvalidTitle.add(1L);
            }
            return null;
        }
        if (titles.stream().filter(t -> t != null && t.equals("Title Not Supplied")).count() > 0L) {
            if (this.titleNotProvidedAcc != null) {
                this.titleNotProvidedAcc.add(1L);
            }
            return null;
        }
        publication.setTitle(titles.stream().map(t -> this.mapStructuredProperty((String)t, ModelConstants.MAIN_TITLE_QUALIFIER, null)).filter(Objects::nonNull).collect(Collectors.toList()));
        String id = DumpToActionsUtility.getStringValue(rootElement, "id");
        String sourceId = null;
        if (id != null) {
            publication.setOriginalId(Arrays.asList(id));
            sourceId = String.format("50|%s::%s", orcidPREFIX, DHPUtils.md5((String)id.toLowerCase()));
        } else {
            String mergedTitle = titles.stream().map(Object::toString).collect(Collectors.joining(","));
            sourceId = String.format("50|%s::%s", orcidPREFIX, DHPUtils.md5((String)mergedTitle.toLowerCase()));
        }
        publication.setId(sourceId);
        this.settingRelevantDate(rootElement, publication, "issued", true);
        publication.setCollectedfrom(Arrays.asList(this.createCollectedFrom()));
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        String cobjValue = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            publication.setResourcetype(this.mapQualifier(type, type, "dnet:dataCite_resource", "dnet:dataCite_resource"));
            Map<String, String> publicationType = typologiesMapping.get(type);
            if ((publicationType == null || publicationType.isEmpty()) && this.errorsInvalidType != null) {
                this.errorsInvalidType.add(1L);
                logger.error("publication_type_not_found: {}", (Object)type);
                return null;
            }
            typeValue = typologiesMapping.get(type).get("value");
            cobjValue = typologiesMapping.get(type).get("cobj");
            if (cobjValue.equals("0020")) {
                if (this.otherTypeFound != null) {
                    this.otherTypeFound.add(1L);
                }
                return null;
            }
            instance = new Instance();
            instance.setHostedby(this.createHostedBy());
            List<String> urls = this.createRepeatedField(rootElement, "urls");
            if (urls == null || urls.isEmpty()) {
                if (this.noUrlAcc != null) {
                    this.noUrlAcc.add(1L);
                }
                return null;
            }
            instance.setUrl(urls);
            dataInfo.setInvisible(Boolean.valueOf(true));
            String pubDate = this.getPublicationDate(rootElement, "publicationDates");
            if (StringUtils.isNotBlank((CharSequence)pubDate)) {
                instance.setDateofacceptance(this.mapStringField(pubDate, null));
            }
        } else {
            if (this.errorsInvalidType != null) {
                this.errorsInvalidType.add(1L);
            }
            return null;
        }
        instance.setCollectedfrom(this.createCollectedFrom());
        instance.setAccessright(OafMapperUtils.accessRight((String)"UNKNOWN", (String)"Unknown", (String)"dnet:access_modes", (String)"dnet:access_modes"));
        instance.setInstancetype(this.mapQualifier(cobjValue, typeValue, "dnet:publication_resource", "dnet:publication_resource"));
        publication.setInstance(Arrays.asList(instance));
        List<Author> authors = this.createAuthors(rootElement);
        if (authors != null && !authors.isEmpty()) {
            if (authors.stream().filter(a -> Objects.nonNull(a.getName()) && a.getName().equals(DEACTIVATED_NAME) || Objects.nonNull(a.getSurname()) && a.getSurname().equals(DEACTIVATED_SURNAME)).count() > 0L) {
                if (this.deactivatedAcc != null) {
                    this.deactivatedAcc.add(1L);
                }
                return null;
            }
        } else {
            if (authors == null) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                throw new RuntimeException("not_valid_authors: " + gson.toJson((JsonElement)rootElement));
            }
            if (this.errorsNotFoundAuthors != null) {
                this.errorsNotFoundAuthors.add(1L);
            }
            return null;
        }
        publication.setAuthor(authors);
        String classValue = DumpToActionsUtility.getDefaultResulttype(cobjValue);
        publication.setResulttype(this.mapQualifier(classValue, classValue, "dnet:result_typologies", "dnet:result_typologies"));
        if (this.enrichedPublications != null) {
            this.enrichedPublications.add(1L);
        }
        return publication;
    }

    public List<Author> createAuthors(JsonObject root) {
        String authorsJSONFieldName = "contributors";
        if (root.has("contributors") && root.get("contributors").isJsonArray()) {
            ArrayList<Author> authors = new ArrayList<Author>();
            JsonArray jsonAuthors = root.getAsJsonArray("contributors");
            int firstCounter = 0;
            int defaultCounter = 0;
            int rank = 1;
            int currentRank = 0;
            for (JsonElement item : jsonAuthors) {
                JsonObject jsonAuthor = item.getAsJsonObject();
                Author author = new Author();
                if (item.isJsonObject()) {
                    String creditname = DumpToActionsUtility.getStringValue(jsonAuthor, "creditName");
                    String surname = DumpToActionsUtility.getStringValue(jsonAuthor, "surname");
                    String name = DumpToActionsUtility.getStringValue(jsonAuthor, "name");
                    String oid = DumpToActionsUtility.getStringValue(jsonAuthor, "oid");
                    String seq = DumpToActionsUtility.getStringValue(jsonAuthor, "sequence");
                    if (StringUtils.isNotBlank((CharSequence)seq)) {
                        rank = seq.equals("first") ? ++firstCounter : (seq.equals("additional") ? currentRank + 1 : ++defaultCounter);
                    }
                    if (StringUtils.isNotBlank((CharSequence)oid)) {
                        author.setPid(Arrays.asList(this.mapAuthorId(oid)));
                        author.setFullname(name + " " + surname);
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            author.setName(name);
                        }
                        if (StringUtils.isNotBlank((CharSequence)surname)) {
                            author.setSurname(surname);
                        }
                    } else {
                        PacePerson p = new PacePerson(creditname, false);
                        if (p.isAccurate()) {
                            author.setName(p.getNormalisedFirstName());
                            author.setSurname(p.getNormalisedSurname());
                            author.setFullname(p.getNormalisedFullname());
                        } else {
                            author.setFullname(creditname);
                        }
                    }
                }
                author.setRank(Integer.valueOf(rank));
                authors.add(author);
                currentRank = rank;
            }
            return authors;
        }
        return null;
    }

    private List<String> createRepeatedField(JsonObject rootElement, String fieldName) {
        if (!rootElement.has(fieldName)) {
            return null;
        }
        if (rootElement.has(fieldName) && rootElement.get(fieldName).isJsonNull()) {
            return null;
        }
        if (rootElement.get(fieldName).isJsonArray()) {
            if (!this.isValidJsonArray(rootElement, fieldName)) {
                return null;
            }
            return DumpToActionsUtility.getArrayValues(rootElement, fieldName);
        }
        String field = DumpToActionsUtility.getStringValue(rootElement, fieldName);
        return Arrays.asList(this.cleanField(field));
    }

    private String cleanField(String value) {
        if (value != null && !value.isEmpty() && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private void settingRelevantDate(JsonObject rootElement, Publication publication, String dictionaryKey, boolean addToDateOfAcceptance) {
        String pubDate = this.getPublicationDate(rootElement, "publication_date");
        if (StringUtils.isNotBlank((CharSequence)pubDate)) {
            if (addToDateOfAcceptance) {
                publication.setDateofacceptance(this.mapStringField(pubDate, null));
            }
            Qualifier q = this.mapQualifier(dictionaryKey, dictionaryKey, "dnet:dataCite_date", "dnet:dataCite_date");
            publication.setRelevantdate(Arrays.asList(pubDate).stream().map(r -> this.mapStructuredProperty((String)r, q, null)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }

    private String getPublicationDate(JsonObject rootElement, String jsonKey) {
        JsonObject pubDateJson = null;
        try {
            pubDateJson = rootElement.getAsJsonObject(jsonKey);
        }
        catch (Exception e) {
            return null;
        }
        if (pubDateJson == null) {
            return null;
        }
        String year = DumpToActionsUtility.getStringValue(pubDateJson, "year");
        String month = DumpToActionsUtility.getStringValue(pubDateJson, "month");
        String day = DumpToActionsUtility.getStringValue(pubDateJson, "day");
        if (StringUtils.isBlank((CharSequence)year)) {
            return null;
        }
        String pubDate = "".concat(year);
        if (StringUtils.isNotBlank((CharSequence)month)) {
            pubDate = pubDate.concat("-" + month);
            pubDate = StringUtils.isNotBlank((CharSequence)day) ? pubDate.concat("-" + day) : pubDate + "-01";
        } else {
            pubDate = pubDate + "-01-01";
        }
        if (DumpToActionsUtility.isValidDate(pubDate)) {
            return pubDate;
        }
        return null;
    }

    protected boolean isValid(JsonObject rootElement) {
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        if (!typologiesMapping.containsKey(type)) {
            logger.error("unknowntype_{}", (Object)type);
            if (this.errorsInvalidType != null) {
                this.errorsInvalidType.add(1L);
            }
            return false;
        }
        if (!this.isValidJsonArray(rootElement, "titles")) {
            if (this.errorsInvalidTitle != null) {
                this.errorsInvalidTitle.add(1L);
            }
            return false;
        }
        return true;
    }

    private boolean isValidJsonArray(JsonObject rootElement, String fieldName) {
        if (!rootElement.has(fieldName)) {
            return false;
        }
        JsonElement jsonElement = rootElement.get(fieldName);
        if (jsonElement.isJsonNull()) {
            return false;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.isJsonNull()) {
                return false;
            }
            return !jsonArray.get(0).isJsonNull();
        }
        return true;
    }

    private Qualifier mapQualifier(String classId, String className, String schemeId, String schemeName) {
        Qualifier qualifier = new Qualifier();
        qualifier.setClassid(classId);
        qualifier.setClassname(className);
        qualifier.setSchemeid(schemeId);
        qualifier.setSchemename(schemeName);
        return qualifier;
    }

    private ExternalReference convertExtRef(String extId, String classId, String className, String schemeId, String schemeName) {
        ExternalReference ex = new ExternalReference();
        ex.setRefidentifier(extId);
        ex.setQualifier(this.mapQualifier(classId, className, schemeId, schemeName));
        return ex;
    }

    private StructuredProperty mapStructuredProperty(String value, Qualifier qualifier, DataInfo dataInfo) {
        if (value == null || StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        StructuredProperty structuredProperty = new StructuredProperty();
        structuredProperty.setValue(value);
        structuredProperty.setQualifier(qualifier);
        structuredProperty.setDataInfo(dataInfo);
        return structuredProperty;
    }

    private Field<String> mapStringField(String value, DataInfo dataInfo) {
        if (value == null || StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Field stringField = new Field();
        stringField.setValue((Object)value);
        stringField.setDataInfo(dataInfo);
        return stringField;
    }

    private KeyValue createCollectedFrom() {
        KeyValue cf = new KeyValue();
        cf.setValue("orcid".toUpperCase());
        cf.setKey("10|openaire____::806360c771262b4d6770e7cdf04b5c5a");
        return cf;
    }

    private KeyValue createHostedBy() {
        return ModelConstants.UNKNOWN_REPOSITORY;
    }

    private StructuredProperty mapAuthorId(String orcidId) {
        StructuredProperty sp = new StructuredProperty();
        sp.setValue(orcidId);
        Qualifier q = new Qualifier();
        q.setClassid("orcid");
        q.setClassname("Open Researcher and Contributor ID");
        q.setSchemeid("dnet:pid_types");
        q.setSchemename("dnet:pid_types");
        sp.setQualifier(q);
        DataInfo dataInfo = new DataInfo();
        dataInfo.setDeletedbyinference(Boolean.valueOf(false));
        dataInfo.setInferred(Boolean.valueOf(false));
        dataInfo.setTrust("0.91");
        dataInfo.setProvenanceaction(this.mapQualifier("sysimport:crosswalk:entityregistry", "Harvested", "dnet:provenanceActions", "dnet:provenanceActions"));
        sp.setDataInfo(dataInfo);
        return sp;
    }

    static {
        try {
            String tt = IOUtils.toString((InputStream)PublicationToOaf.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/orcidnodoi/mappings/typologies.json"));
            typologiesMapping = (Map)new Gson().fromJson(tt, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException("loading typologies", e);
        }
    }
}

