/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid.xml;

import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import eu.dnetlib.dhp.parser.utility.VtdException;
import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import eu.dnetlib.dhp.schema.orcid.AuthorData;
import eu.dnetlib.dhp.schema.orcid.AuthorHistory;
import eu.dnetlib.dhp.schema.orcid.AuthorSummary;
import eu.dnetlib.doiboost.orcid.model.WorkData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mortbay.log.Log;

public class XMLRecordParser {
    private static final String NS_COMMON_URL = "http://www.orcid.org/ns/common";
    private static final String NS_COMMON = "common";
    private static final String NS_PERSON_URL = "http://www.orcid.org/ns/person";
    private static final String NS_PERSON = "person";
    private static final String NS_DETAILS_URL = "http://www.orcid.org/ns/personal-details";
    private static final String NS_DETAILS = "personal-details";
    private static final String NS_OTHER_URL = "http://www.orcid.org/ns/other-name";
    private static final String NS_OTHER = "other-name";
    private static final String NS_RECORD_URL = "http://www.orcid.org/ns/record";
    private static final String NS_RECORD = "record";
    private static final String NS_ERROR_URL = "http://www.orcid.org/ns/error";
    private static final String NS_ACTIVITIES = "activities";
    private static final String NS_ACTIVITIES_URL = "http://www.orcid.org/ns/activities";
    private static final String NS_WORK = "work";
    private static final String NS_WORK_URL = "http://www.orcid.org/ns/work";
    private static final String NS_HISTORY = "history";
    private static final String NS_HISTORY_URL = "http://www.orcid.org/ns/history";
    private static final String NS_BULK_URL = "http://www.orcid.org/ns/bulk";
    private static final String NS_BULK = "bulk";
    private static final String namespaceList = " xmlns:internal=\"http://www.orcid.org/ns/internal\"\n    xmlns:education=\"http://www.orcid.org/ns/education\"\n    xmlns:distinction=\"http://www.orcid.org/ns/distinction\"\n    xmlns:deprecated=\"http://www.orcid.org/ns/deprecated\"\n    xmlns:other-name=\"http://www.orcid.org/ns/other-name\"\n    xmlns:membership=\"http://www.orcid.org/ns/membership\"\n    xmlns:error=\"http://www.orcid.org/ns/error\" xmlns:common=\"http://www.orcid.org/ns/common\"\n    xmlns:record=\"http://www.orcid.org/ns/record\"\n    xmlns:personal-details=\"http://www.orcid.org/ns/personal-details\"\n    xmlns:keyword=\"http://www.orcid.org/ns/keyword\" xmlns:email=\"http://www.orcid.org/ns/email\"\n    xmlns:external-identifier=\"http://www.orcid.org/ns/external-identifier\"\n    xmlns:funding=\"http://www.orcid.org/ns/funding\"\n    xmlns:preferences=\"http://www.orcid.org/ns/preferences\"\n    xmlns:address=\"http://www.orcid.org/ns/address\"\n    xmlns:invited-position=\"http://www.orcid.org/ns/invited-position\"\n    xmlns:work=\"http://www.orcid.org/ns/work\" xmlns:history=\"http://www.orcid.org/ns/history\"\n    xmlns:employment=\"http://www.orcid.org/ns/employment\"\n    xmlns:qualification=\"http://www.orcid.org/ns/qualification\"\n    xmlns:service=\"http://www.orcid.org/ns/service\" xmlns:person=\"http://www.orcid.org/ns/person\"\n    xmlns:activities=\"http://www.orcid.org/ns/activities\"\n    xmlns:researcher-url=\"http://www.orcid.org/ns/researcher-url\"\n    xmlns:peer-review=\"http://www.orcid.org/ns/peer-review\"\n    xmlns:bulk=\"http://www.orcid.org/ns/bulk\"\n    xmlns:research-resource=\"http://www.orcid.org/ns/research-resource\"";
    private static final String NS_ERROR = "error";

    private XMLRecordParser() {
    }

    public static AuthorData VTDParseAuthorData(byte[] bytes) throws VtdException, ParseException {
        List otherNames;
        List creditNames;
        List surnames;
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_PERSON, NS_PERSON_URL);
        ap.declareXPathNameSpace(NS_DETAILS, NS_DETAILS_URL);
        ap.declareXPathNameSpace(NS_OTHER, NS_OTHER_URL);
        ap.declareXPathNameSpace(NS_RECORD, NS_RECORD_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        ap.declareXPathNameSpace(NS_HISTORY, NS_HISTORY_URL);
        AuthorData authorData = new AuthorData();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            authorData.setErrorCode((String)errors.get(0));
            return authorData;
        }
        List recordNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//record:record", Arrays.asList("path"));
        if (recordNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)recordNodes.get(0)).getAttributes().get("path")).substring(1);
        authorData.setOid(oid);
        List names = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:given-names");
        if (!names.isEmpty()) {
            authorData.setName((String)names.get(0));
        }
        if (!(surnames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:family-name")).isEmpty()) {
            authorData.setSurname((String)surnames.get(0));
        }
        if (!(creditNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:credit-name")).isEmpty()) {
            authorData.setCreditName((String)creditNames.get(0));
        }
        if (!(otherNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//other-name:content")).isEmpty()) {
            authorData.setOtherNames(otherNames);
        }
        return authorData;
    }

    public static WorkData VTDParseWorkData(byte[] bytes) throws VtdException, ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        WorkData workData = new WorkData();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            workData.setErrorCode((String)errors.get(0));
            return workData;
        }
        List workNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//work:work", Arrays.asList("path"));
        if (workNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("path")).split("/")[1];
        workData.setOid(oid);
        List dois = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//common:external-id-type[text()=\"doi\"]/../common:external-id-value");
        if (!dois.isEmpty()) {
            workData.setDoi((String)dois.get(0));
            workData.setDoiFound(true);
        }
        return workData;
    }

    public static String retrieveOrcidIdFromSummary(byte[] bytes, String defaultValue) throws VtdException, ParseException {
        return XMLRecordParser.retrieveOrcidId(bytes, defaultValue, NS_RECORD, NS_RECORD_URL, "//record:record", "path").substring(1);
    }

    public static String retrieveOrcidIdFromActivity(byte[] bytes, String defaultValue) throws VtdException, ParseException {
        return XMLRecordParser.retrieveOrcidId(bytes, defaultValue, NS_WORK, NS_WORK_URL, "//work:work", "put-code");
    }

    public static String retrieveWorkIdFromSummary(byte[] bytes, String defaultValue) throws VtdException, ParseException {
        return XMLRecordParser.retrieveOrcidId(bytes, defaultValue, NS_ACTIVITIES, NS_ACTIVITIES_URL, "//work:work-summary", "put-code");
    }

    private static String retrieveOrcidId(byte[] bytes, String defaultValue, String ns, String nsUrl, String xpath, String idAttributeName) throws VtdException, ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(ns, nsUrl);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        List recordNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)xpath, Arrays.asList(idAttributeName));
        if (!recordNodes.isEmpty()) {
            return (String)((VtdUtilityParser.Node)recordNodes.get(0)).getAttributes().get(idAttributeName);
        }
        Log.info((String)("id not found - default: " + defaultValue));
        return defaultValue;
    }

    public static Map<String, String> retrieveWorkIdLastModifiedDate(byte[] bytes) throws ParseException, XPathParseException, NavException, XPathEvalException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        HashMap<String, String> workIdLastModifiedDate = new HashMap<String, String>();
        ap.selectXPath("//work:work-summary");
        String workId = "";
        while (ap.evalXPath() != -1) {
            String lastModifiedDate = "";
            int attr = vn.getAttrVal("put-code");
            if (attr > -1) {
                workId = vn.toNormalizedString(attr);
            }
            if (!vn.toElement(2, "common:last-modified-date")) continue;
            int val = vn.getText();
            if (val != -1) {
                lastModifiedDate = vn.toNormalizedString(val);
                workIdLastModifiedDate.put(workId, lastModifiedDate);
            }
            vn.toElement(1);
        }
        return workIdLastModifiedDate;
    }

    public static AuthorSummary VTDParseAuthorSummary(byte[] bytes) throws VtdException, ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_PERSON, NS_PERSON_URL);
        ap.declareXPathNameSpace(NS_DETAILS, NS_DETAILS_URL);
        ap.declareXPathNameSpace(NS_OTHER, NS_OTHER_URL);
        ap.declareXPathNameSpace(NS_RECORD, NS_RECORD_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        ap.declareXPathNameSpace(NS_HISTORY, NS_HISTORY_URL);
        AuthorData authorData = XMLRecordParser.retrieveAuthorData(ap, vn);
        AuthorHistory authorHistory = XMLRecordParser.retrieveAuthorHistory(ap, vn);
        AuthorSummary authorSummary = new AuthorSummary();
        authorSummary.setAuthorData(authorData);
        authorSummary.setAuthorHistory(authorHistory);
        return authorSummary;
    }

    private static AuthorData retrieveAuthorData(AutoPilot ap, VTDNav vn) throws VtdException {
        List otherNames;
        List creditNames;
        List surnames;
        AuthorData authorData = new AuthorData();
        List errors = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//error:response-code");
        if (!errors.isEmpty()) {
            authorData.setErrorCode((String)errors.get(0));
            return authorData;
        }
        List recordNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//record:record", Arrays.asList("path"));
        if (recordNodes.isEmpty()) {
            return null;
        }
        String oid = ((String)((VtdUtilityParser.Node)recordNodes.get(0)).getAttributes().get("path")).substring(1);
        authorData.setOid(oid);
        List names = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:given-names");
        if (!names.isEmpty()) {
            authorData.setName((String)names.get(0));
        }
        if (!(surnames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:family-name")).isEmpty()) {
            authorData.setSurname((String)surnames.get(0));
        }
        if (!(creditNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//personal-details:credit-name")).isEmpty()) {
            authorData.setCreditName((String)creditNames.get(0));
        }
        if (!(otherNames = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//other-name:content")).isEmpty()) {
            authorData.setOtherNames(otherNames);
        }
        return authorData;
    }

    private static AuthorHistory retrieveAuthorHistory(AutoPilot ap, VTDNav vn) throws VtdException {
        AuthorHistory authorHistory = new AuthorHistory();
        String creationMethod = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:creation-method");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creationMethod})) {
            authorHistory.setCreationMethod(creationMethod);
        }
        String completionDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:completion-date");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{completionDate})) {
            authorHistory.setCompletionDate(completionDate);
        }
        String submissionDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:submission-date");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{submissionDate})) {
            authorHistory.setSubmissionDate(submissionDate);
        }
        String claimed = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:claimed");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{claimed})) {
            authorHistory.setClaimed(Boolean.parseBoolean(claimed));
        }
        String verifiedEmail = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:verified-email");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{verifiedEmail})) {
            authorHistory.setVerifiedEmail(Boolean.parseBoolean(verifiedEmail));
        }
        String verifiedPrimaryEmail = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:verified-primary-email");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{verifiedPrimaryEmail})) {
            authorHistory.setVerifiedPrimaryEmail(Boolean.parseBoolean(verifiedPrimaryEmail));
        }
        String deactivationDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:deactivation-date");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deactivationDate})) {
            authorHistory.setDeactivationDate(deactivationDate);
        }
        String lastModifiedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//history:history/common:last-modified-date");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lastModifiedDate})) {
            authorHistory.setLastModifiedDate(lastModifiedDate);
        }
        return authorHistory;
    }

    public static List<String> splitWorks(String orcidId, byte[] bytes) throws ParseException, XPathParseException, NavException, XPathEvalException, VtdException, ModifyException, IOException, TranscodeException {
        VTDGen vg = new VTDGen();
        vg.setDoc(bytes);
        vg.parse(true);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        ap.declareXPathNameSpace(NS_BULK, NS_BULK_URL);
        ArrayList<String> works = new ArrayList<String>();
        try {
            ap.selectXPath("//work:work");
            while (ap.evalXPath() != -1) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                long l = vn.getElementFragment();
                String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
                bos.write(xmlHeader.getBytes(StandardCharsets.UTF_8));
                bos.write(vn.getXML().getBytes(), (int)l, (int)(l >> 32));
                works.add(bos.toString());
                bos.close();
            }
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
        List<VTDGen> vgModifiers = Arrays.asList(new VTDGen());
        List<XMLModifier> xmModifiers = Arrays.asList(new XMLModifier());
        List<ByteArrayOutputStream> buffer = Arrays.asList(new ByteArrayOutputStream());
        List<String> updatedWorks = works.stream().map(work -> {
            ((VTDGen)vgModifiers.get(0)).setDoc(work.getBytes());
            try {
                ((VTDGen)vgModifiers.get(0)).parse(false);
                VTDNav vnModifier = ((VTDGen)vgModifiers.get(0)).getNav();
                ((XMLModifier)xmModifiers.get(0)).bind(vnModifier);
                vnModifier.toElement(0);
                int attr = vnModifier.getAttrVal("put-code");
                if (attr > -1) {
                    ((XMLModifier)xmModifiers.get(0)).insertAttribute(" path=\"/" + orcidId + "/work/" + vnModifier.toNormalizedString(attr) + "\" " + namespaceList);
                }
                buffer.set(0, new ByteArrayOutputStream());
                ((XMLModifier)xmModifiers.get(0)).output((OutputStream)buffer.get(0));
                ((ByteArrayOutputStream)buffer.get(0)).close();
                return ((ByteArrayOutputStream)buffer.get(0)).toString();
            }
            catch (ModifyException | NavException | ParseException | TranscodeException | IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return updatedWorks;
    }
}

