/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi;

import eu.dnetlib.dhp.schema.orcid.WorkDetail;
import eu.dnetlib.doiboost.orcid.json.JsonHelper;
import eu.dnetlib.doiboost.orcidnodoi.xml.XMLRecordParserNoDoi;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.mortbay.log.Log;

public class ActivitiesDumpReader {
    private static final int MAX_XML_WORKS_PARSED = -1;
    private static final int XML_WORKS_PARSED_COUNTER_LOG_INTERVAL = 100000;

    private ActivitiesDumpReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseGzActivities(Configuration conf, String inputUri, Path outputPath) throws Exception {
        String uri = inputUri;
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        Path inputPath = new Path(uri);
        CompressionCodec codec = factory.getCodec(inputPath);
        if (codec == null) {
            System.err.println("No codec found for " + uri);
            System.exit(1);
        }
        CompressionCodecFactory.removeSuffix((String)uri, (String)codec.getDefaultExtension());
        CompressionInputStream gzipInputStream = null;
        try {
            gzipInputStream = codec.createInputStream((InputStream)fs.open(inputPath));
            ActivitiesDumpReader.parseTarActivities(conf, (InputStream)gzipInputStream, outputPath);
        }
        finally {
            Log.debug((String)"Closing gzip stream");
            IOUtils.closeStream((Closeable)gzipInputStream);
        }
    }

    private static void parseTarActivities(Configuration conf, InputStream gzipInputStream, Path outputPath) {
        int counter = 0;
        int noDoiFound = 0;
        int errorFromOrcidFound = 0;
        int xmlParserErrorFound = 0;
        try (TarArchiveInputStream tais = new TarArchiveInputStream(gzipInputStream);){
            TarArchiveEntry entry = null;
            try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});){
                while ((entry = tais.getNextTarEntry()) != null) {
                    block34: {
                        String filename = entry.getName();
                        StringBuilder builder = new StringBuilder();
                        try {
                            String line;
                            if (entry.isDirectory() || !filename.contains("works")) break block34;
                            Log.debug((String)("XML work entry name: " + entry.getName()));
                            ++counter;
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tais));
                            builder = new StringBuilder();
                            while ((line = br.readLine()) != null) {
                                builder.append(line);
                            }
                            WorkDetail workDetail = XMLRecordParserNoDoi.VTDParseWorkData(builder.toString().getBytes());
                            if (workDetail != null) {
                                if (workDetail.getErrorCode() != null) {
                                    ++errorFromOrcidFound;
                                    Log.debug((String)("error from Orcid with code " + workDetail.getErrorCode() + " for entry " + entry.getName()));
                                    continue;
                                }
                                boolean isDoiFound = workDetail.getExtIds().stream().filter(e -> e.getType() != null).anyMatch(e -> e.getType().equals("doi"));
                                if (isDoiFound) break block34;
                                String jsonData = JsonHelper.createOidWork(workDetail);
                                Log.debug((String)("oid: " + workDetail.getOid() + " data: " + jsonData));
                                Text key = new Text(workDetail.getOid());
                                Text value = new Text(jsonData);
                                try {
                                    writer.append((Writable)key, (Writable)value);
                                }
                                catch (IOException e2) {
                                    Log.debug((String)("Writing to sequence file: " + e2.getMessage()));
                                    Log.debug((Throwable)e2);
                                    throw new RuntimeException(e2);
                                }
                                ++noDoiFound;
                                break block34;
                            }
                            Log.warn((String)("Data not retrievable [" + entry.getName() + "] " + builder));
                            ++xmlParserErrorFound;
                        }
                        catch (Exception e3) {
                            throw new Exception(filename, e3);
                        }
                    }
                    if (counter % 100000 != 0) continue;
                    Log.info((String)("Current xml works parsed: " + counter));
                }
            }
        }
        catch (Exception e4) {
            Log.warn((String)("Parsing work from gzip archive: " + e4.getMessage()));
            Log.warn((Throwable)e4);
            throw new RuntimeException(e4);
        }
        Log.info((String)"Activities parse completed");
        Log.info((String)("Total XML works parsed: " + counter));
        Log.info((String)("Total no doi work found: " + noDoiFound));
        Log.info((String)("Error from Orcid found: " + errorFromOrcidFound));
        Log.info((String)("Error parsing xml work found: " + xmlParserErrorFound));
    }
}

