/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcidnodoi.similarity;

import eu.dnetlib.dhp.schema.orcid.AuthorData;
import eu.dnetlib.dhp.schema.orcid.Contributor;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;

public class AuthorMatcher {
    public static final Double THRESHOLD = 0.8;

    private AuthorMatcher() {
    }

    public static void match(AuthorData author, List<Contributor> contributors) {
        int matchCounter = 0;
        List<Integer> matchCounters = Arrays.asList(matchCounter);
        contributors.stream().filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).forEach(c -> {
            if (AuthorMatcher.simpleMatch(c.getCreditName(), author.getName()) || AuthorMatcher.simpleMatch(c.getCreditName(), author.getSurname()) || AuthorMatcher.simpleMatchOnOtherNames(c.getCreditName(), author.getOtherNames())) {
                matchCounters.set(0, (Integer)matchCounters.get(0) + 1);
                c.setSimpleMatch(true);
            }
        });
        if (matchCounters.get(0) == 1) {
            AuthorMatcher.updateAuthorsSimpleMatch(contributors, author);
        } else if (matchCounters.get(0) == 0) {
            Optional<Contributor> optCon = contributors.stream().filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).map(c -> {
                c.setScore(AuthorMatcher.bestMatch(author.getName(), author.getSurname(), c.getCreditName()));
                return c;
            }).filter(c -> c.getScore() >= THRESHOLD).max(Comparator.comparing(Contributor::getScore));
            Contributor bestMatchContributor = null;
            if (optCon.isPresent()) {
                bestMatchContributor = optCon.get();
                bestMatchContributor.setBestMatch(true);
                AuthorMatcher.updateAuthorsSimilarityMatch(contributors, author);
            }
        } else if (matchCounters.get(0) > 1) {
            Optional<Contributor> optCon = contributors.stream().filter(Contributor::isSimpleMatch).filter(c -> !StringUtils.isBlank((CharSequence)c.getCreditName())).map(c -> {
                c.setScore(AuthorMatcher.bestMatch(author.getName(), author.getSurname(), c.getCreditName()));
                return c;
            }).filter(c -> c.getScore() >= THRESHOLD).max(Comparator.comparing(Contributor::getScore));
            Contributor bestMatchContributor = null;
            if (optCon.isPresent()) {
                bestMatchContributor = optCon.get();
                bestMatchContributor.setBestMatch(true);
                AuthorMatcher.updateAuthorsSimilarityMatch(contributors, author);
            }
        }
    }

    public static boolean simpleMatchOnOtherNames(String name, List<String> otherNames) {
        if (otherNames == null || otherNames.isEmpty()) {
            return false;
        }
        return otherNames.stream().filter(o -> AuthorMatcher.simpleMatch(name, o)).count() > 0L;
    }

    public static boolean simpleMatch(String name, String searchValue) {
        if (searchValue == null) {
            return false;
        }
        return AuthorMatcher.normalize(name).contains(AuthorMatcher.normalize(searchValue));
    }

    public static Double bestMatch(String authorSurname, String authorName, String contributor) {
        Double sm2;
        String contributorSurnameNrm;
        String contributorNameNrm;
        String authorSurnameNrm;
        String authorNameNrm;
        Double sm1;
        String[] contributorSplitted = contributor.split(" ");
        if (contributorSplitted.length == 0) {
            return 0.0;
        }
        String contributorName = contributorSplitted[contributorSplitted.length - 1];
        String contributorSurname = "";
        if (contributorSplitted.length > 1) {
            StringJoiner joiner = new StringJoiner(" ");
            for (int i = 0; i < contributorSplitted.length - 1; ++i) {
                joiner.add(contributorSplitted[i]);
            }
            contributorSurname = joiner.toString();
        }
        if ((sm1 = AuthorMatcher.similarity(authorNameNrm = AuthorMatcher.normalize(authorName), authorSurnameNrm = AuthorMatcher.normalize(authorSurname), contributorNameNrm = AuthorMatcher.normalize(contributorName), contributorSurnameNrm = AuthorMatcher.normalize(contributorSurname))).compareTo(sm2 = AuthorMatcher.similarity(authorNameNrm, authorSurnameNrm, contributorSurnameNrm, contributorNameNrm)) >= 0) {
            return sm1;
        }
        return sm2;
    }

    public static Double similarity(String nameA, String surnameA, String nameB, String surnameB) {
        return AuthorMatcher.similarityJaroWinkler(nameA, surnameA, nameB, surnameB);
    }

    private static Double similarityJaroWinkler(String nameA, String surnameA, String nameB, String surnameB) {
        return new JaroWinklerSimilarity().apply((CharSequence)AuthorMatcher.normalize(AuthorMatcher.parse(nameA, surnameA)), (CharSequence)AuthorMatcher.normalize(AuthorMatcher.parse(nameB, surnameB)));
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        return AuthorMatcher.nfd(s).toLowerCase().replaceAll("(\\W)+", " ").replaceAll("(\\p{InCombiningDiacriticalMarks})+", " ").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim();
    }

    private static String nfd(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }

    private static String parse(String name, String surname) {
        return surname + " " + name;
    }

    public static void updateAuthorsSimpleMatch(List<Contributor> contributors, AuthorData author) {
        contributors.forEach(c -> {
            if (c.isSimpleMatch()) {
                c.setName(author.getName());
                c.setSurname(author.getSurname());
                c.setOid(author.getOid());
            }
        });
        AuthorMatcher.updateRanks(contributors);
    }

    public static void updateAuthorsSimilarityMatch(List<Contributor> contributors, AuthorData author) {
        contributors.stream().filter(Contributor::isBestMatch).forEach(c -> {
            c.setName(author.getName());
            c.setSurname(author.getSurname());
            c.setOid(author.getOid());
        });
        AuthorMatcher.updateRanks(contributors);
    }

    private static void updateRanks(List<Contributor> contributors) {
        boolean seqFound;
        boolean bl = seqFound = contributors.stream().filter(c -> c.getRole() != null && c.getSequence() != null && c.getRole().equals("author") && (c.getSequence().equals("first") || c.getSequence().equals("additional"))).count() > 0L;
        if (!seqFound) {
            List<Integer> seqIds = Arrays.asList(0);
            contributors.forEach(c -> {
                int currentSeq = (Integer)seqIds.get(0) + 1;
                seqIds.set(0, currentSeq);
                c.setSequence(Integer.toString((Integer)seqIds.get(0)));
            });
        }
    }
}

