/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSUtil {
    static Logger logger = LoggerFactory.getLogger(HDFSUtil.class);

    private HDFSUtil() {
    }

    private static FileSystem getFileSystem(String hdfsServerUri) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsServerUri);
        return FileSystem.get((Configuration)conf);
    }

    public static String readFromTextFile(String hdfsServerUri, String workingPath, String path) throws IOException {
        Path toReadPath;
        FileSystem fileSystem = HDFSUtil.getFileSystem(hdfsServerUri);
        if (!fileSystem.exists(toReadPath = new Path(workingPath.concat(path)))) {
            throw new IOException("File not exist: " + path);
        }
        logger.info("Last_update_path {}", (Object)toReadPath);
        FSDataInputStream inputStream = new FSDataInputStream((InputStream)fileSystem.open(toReadPath));
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String buffer = sb.toString();
            logger.info("Last_update: {}", (Object)buffer);
            String string = buffer;
            return string;
        }
    }

    public static void writeToTextFile(String hdfsServerUri, String workingPath, String path, String text) throws IOException {
        Path toWritePath;
        FileSystem fileSystem = HDFSUtil.getFileSystem(hdfsServerUri);
        if (fileSystem.exists(toWritePath = new Path(workingPath.concat(path)))) {
            fileSystem.delete(toWritePath, true);
        }
        FSDataOutputStream os = fileSystem.create(toWritePath);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));){
            br.write(text);
        }
    }
}

