/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.doiboost.orcid.model.DownloadedRecordData;
import eu.dnetlib.doiboost.orcid.util.DownloadsReport;
import eu.dnetlib.doiboost.orcid.util.HDFSUtil;
import eu.dnetlib.doiboost.orcid.util.MultiAttemptsHttpConnector;
import eu.dnetlib.doiboost.orcid.xml.XMLRecordParser;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkDownloadOrcidWorks {
    static Logger logger = LoggerFactory.getLogger(SparkDownloadOrcidWorks.class);
    public static final String LAMBDA_FILE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter LAMBDA_FILE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String ORCID_XML_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final DateTimeFormatter ORCID_XML_DATETIMEFORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final String DOWNLOAD_WORKS_REQUEST_SEPARATOR = ",";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkDownloadOrcidWorks.class.getResourceAsStream("/eu/dnetlib/dhp/doiboost/download_orcid_data.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        String workingPath = parser.get("workingPath");
        logger.info("workingPath: {}", (Object)workingPath);
        String outputPath = parser.get("outputPath");
        String token = parser.get("token");
        String hdfsServerUri = parser.get("hdfsServerUri");
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            String lastUpdateValue = HDFSUtil.readFromTextFile(hdfsServerUri, workingPath, "last_update.txt");
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
            LongAccumulator updatedAuthorsAcc = spark.sparkContext().longAccumulator("updated_authors");
            LongAccumulator parsedAuthorsAcc = spark.sparkContext().longAccumulator("parsed_authors");
            LongAccumulator parsedWorksAcc = spark.sparkContext().longAccumulator("parsed_works");
            LongAccumulator modifiedWorksAcc = spark.sparkContext().longAccumulator("modified_works");
            LongAccumulator errorCodeFoundAcc = spark.sparkContext().longAccumulator("error_code_found");
            LongAccumulator errorParsingXMLFoundAcc = spark.sparkContext().longAccumulator("error_parsing_xml_found");
            LongAccumulator downloadedRecordsAcc = spark.sparkContext().longAccumulator("downloaded_records");
            JavaPairRDD updatedAuthorsRDD = sc.sequenceFile(workingPath + "downloads/updated_authors/*", Text.class, Text.class);
            long authorsCount = updatedAuthorsRDD.count();
            updatedAuthorsAcc.setValue(authorsCount);
            FlatMapFunction & Serializable retrieveWorkUrlFunction = (FlatMapFunction & Serializable)data -> {
                String orcidId = ((Text)data._1()).toString();
                String jsonData = ((Text)data._2()).toString();
                ArrayList workIds = new ArrayList();
                Map<String, String> workIdLastModifiedDate = new HashMap<String, String>();
                JsonElement jElement = new JsonParser().parse(jsonData);
                String statusCode = SparkDownloadOrcidWorks.getJsonValue(jElement, "statusCode");
                if (statusCode.equals("200")) {
                    String authorSummary;
                    String compressedData = SparkDownloadOrcidWorks.getJsonValue(jElement, "compressedData");
                    if (!StringUtils.isEmpty((CharSequence)compressedData) && !StringUtils.isEmpty((CharSequence)(authorSummary = ArgumentApplicationParser.decompressValue((String)compressedData)))) {
                        try {
                            workIdLastModifiedDate = XMLRecordParser.retrieveWorkIdLastModifiedDate(authorSummary.getBytes());
                        }
                        catch (Exception e) {
                            logger.error("parsing " + orcidId + " [" + jsonData + "]", (Throwable)e);
                            errorParsingXMLFoundAcc.add(1L);
                        }
                    }
                } else {
                    errorCodeFoundAcc.add(1L);
                }
                parsedAuthorsAcc.add(1L);
                workIdLastModifiedDate.forEach((k, v) -> {
                    parsedWorksAcc.add(1L);
                    if (SparkDownloadOrcidWorks.isModified(orcidId, v, lastUpdateValue)) {
                        modifiedWorksAcc.add(1L);
                        workIds.add(k);
                    }
                });
                if (workIds.isEmpty()) {
                    return new ArrayList().iterator();
                }
                ArrayList worksDownloadUrls = new ArrayList();
                List partitionedWorks = Lists.partition(workIds, (int)100);
                partitionedWorks.stream().forEach(p -> {
                    String worksDownloadUrl = orcidId.concat("/works/");
                    StringBuffer buffer = new StringBuffer(worksDownloadUrl);
                    p.forEach(id -> buffer.append((String)id).append(DOWNLOAD_WORKS_REQUEST_SEPARATOR));
                    String finalUrl = buffer.substring(0, buffer.lastIndexOf(DOWNLOAD_WORKS_REQUEST_SEPARATOR));
                    worksDownloadUrls.add(finalUrl);
                });
                return worksDownloadUrls.iterator();
            };
            Function & Serializable downloadWorksFunction = (Function & Serializable)data -> {
                String relativeWorksUrl = data;
                String orcidId = relativeWorksUrl.split("/")[0];
                DownloadedRecordData downloaded = new DownloadedRecordData();
                downloaded.setOrcidId(orcidId);
                downloaded.setLastModifiedDate(lastUpdateValue);
                HttpClientParams clientParams = new HttpClientParams();
                MultiAttemptsHttpConnector httpConnector = new MultiAttemptsHttpConnector(clientParams);
                httpConnector.setAuthMethod("BEARER");
                httpConnector.setAcceptHeaderValue("application/vnd.orcid+xml");
                httpConnector.setAuthToken(token);
                String apiUrl = "https://api.orcid.org/v3.0/" + relativeWorksUrl;
                DownloadsReport report = new DownloadsReport();
                long startReq = System.currentTimeMillis();
                boolean downloadCompleted = false;
                String record = "";
                try {
                    record = httpConnector.getInputSource(apiUrl, report);
                    downloadCompleted = true;
                }
                catch (CollectorException ce) {
                    if (!report.isEmpty()) {
                        int errCode = (Integer)report.keySet().stream().findFirst().get();
                        report.forEach((k, v) -> logger.error(k + " " + v));
                        downloaded.setStatusCode(errCode);
                    }
                    downloaded.setStatusCode(-4);
                }
                long endReq = System.currentTimeMillis();
                long reqTime = endReq - startReq;
                if (reqTime < 1000L) {
                    Thread.sleep(1000L - reqTime);
                }
                if (downloadCompleted) {
                    downloaded.setStatusCode(200);
                    downloaded.setCompressedData(ArgumentApplicationParser.compressArgument((String)record));
                }
                return downloaded.toTuple2();
            };
            FlatMapFunction & Serializable splitWorksFunction = (FlatMapFunction & Serializable)data -> {
                ArrayList<Tuple2<String, String>> splittedDownloadedWorks = new ArrayList<Tuple2<String, String>>();
                String jsonData = ((String)data._2()).toString();
                JsonElement jElement = new JsonParser().parse(jsonData);
                String orcidId = ((String)data._1()).toString();
                String statusCode = SparkDownloadOrcidWorks.getJsonValue(jElement, "statusCode");
                String lastModifiedDate = SparkDownloadOrcidWorks.getJsonValue(jElement, "lastModifiedDate");
                String compressedData = SparkDownloadOrcidWorks.getJsonValue(jElement, "compressedData");
                String errorMessage = SparkDownloadOrcidWorks.getJsonValue(jElement, "errorMessage");
                String works = ArgumentApplicationParser.decompressValue((String)compressedData);
                List<String> splittedWorks = null;
                try {
                    splittedWorks = XMLRecordParser.splitWorks(orcidId, works.getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable t) {
                    DownloadedRecordData errDownloaded = new DownloadedRecordData();
                    errDownloaded.setOrcidId(orcidId);
                    errDownloaded.setLastModifiedDate(lastModifiedDate);
                    errDownloaded.setStatusCode(-10);
                    errDownloaded.setErrorMessage(t.getMessage());
                    splittedDownloadedWorks.add(errDownloaded.toTuple2());
                    errorParsingXMLFoundAcc.add(1L);
                    return splittedDownloadedWorks.iterator();
                }
                splittedWorks.forEach(w -> {
                    DownloadedRecordData downloaded = new DownloadedRecordData();
                    downloaded.setOrcidId(orcidId);
                    downloaded.setLastModifiedDate(lastModifiedDate);
                    downloaded.setStatusCode(Integer.parseInt(statusCode));
                    downloaded.setErrorMessage(errorMessage);
                    try {
                        downloaded.setCompressedData(ArgumentApplicationParser.compressArgument((String)w));
                    }
                    catch (Throwable t) {
                        downloaded.setStatusCode(-11);
                        downloaded.setErrorMessage(t.getMessage());
                    }
                    splittedDownloadedWorks.add(downloaded.toTuple2());
                    downloadedRecordsAcc.add(1L);
                });
                return splittedDownloadedWorks.iterator();
            };
            updatedAuthorsRDD.flatMap((FlatMapFunction)retrieveWorkUrlFunction).repartition(100).map((Function)downloadWorksFunction).flatMap((FlatMapFunction)splitWorksFunction).mapToPair((PairFunction & Serializable)w -> new Tuple2((Object)new Text((String)w._1()), (Object)new Text((String)w._2()))).saveAsTextFile(workingPath.concat(outputPath), GzipCodec.class);
            logger.info("updatedAuthorsAcc: {}", (Object)updatedAuthorsAcc.value());
            logger.info("parsedAuthorsAcc: {}", (Object)parsedAuthorsAcc.value());
            logger.info("parsedWorksAcc: {}", (Object)parsedWorksAcc.value());
            logger.info("modifiedWorksAcc: {}", (Object)modifiedWorksAcc.value());
            logger.info("errorCodeFoundAcc: {}", (Object)errorCodeFoundAcc.value());
            logger.info("errorParsingXMLFoundAcc: {}", (Object)errorParsingXMLFoundAcc.value());
            logger.info("downloadedRecordsAcc: {}", (Object)downloadedRecordsAcc.value());
        });
    }

    public static boolean isModified(String orcidId, String modifiedDateValue, String lastUpdateValue) {
        LocalDate modifiedDate = null;
        LocalDate lastUpdate = null;
        try {
            modifiedDate = LocalDate.parse(modifiedDateValue, ORCID_XML_DATETIMEFORMATTER);
            if (lastUpdateValue.length() != 19) {
                lastUpdateValue = lastUpdateValue.substring(0, 19);
            }
            lastUpdate = LocalDate.parse(lastUpdateValue, LAMBDA_FILE_DATE_FORMATTER);
        }
        catch (Exception e) {
            logger.info("[" + orcidId + "] Parsing date: ", (Object)e.getMessage());
            throw new RuntimeException("[" + orcidId + "] Parsing date: " + e.getMessage());
        }
        return modifiedDate.isAfter(lastUpdate);
    }

    private static String getJsonValue(JsonElement jElement, String property) {
        if (jElement.getAsJsonObject().has(property)) {
            JsonElement name = null;
            name = jElement.getAsJsonObject().get(property);
            if (name != null && !name.isJsonNull()) {
                return name.getAsString();
            }
        }
        return "";
    }
}

