/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.model.graph;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import eu.dnetlib.dhp.oa.model.Provenance;
import eu.dnetlib.dhp.oa.model.graph.RelType;
import java.io.Serializable;
import java.util.Objects;

public class Relation
implements Serializable {
    @JsonSchema(description="The identifier of the source in the relation")
    private String source;
    @JsonSchema(description="The entity type of the source in the relation")
    private String sourceType;
    @JsonSchema(description="The identifier of the target in the relation")
    private String target;
    @JsonSchema(description="The entity type of the target in the relation")
    private String targetType;
    @JsonSchema(description="To represent the semantics of a relation between two entities")
    private RelType relType;
    @JsonSchema(description="The reason why OpenAIRE holds the relation ")
    private Provenance provenance;
    @JsonSchema(description="True if the relation is related to a project and it has been collected from an authoritative source (i.e. the funder)")
    private boolean validated;
    @JsonSchema(description="The date when the relation was collected from OpenAIRE")
    private String validationDate;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public RelType getRelType() {
        return this.relType;
    }

    public void setRelType(RelType relType) {
        this.relType = relType;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public void setValidated(boolean validate) {
        this.validated = validate;
    }

    public boolean getValidated() {
        return this.validated;
    }

    public void setValidationDate(String validationDate) {
        this.validationDate = validationDate;
    }

    public String getValidationDate() {
        return this.validationDate;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.relType.getType() + ":" + this.relType.getName());
    }

    public static Relation newInstance(String source, String sourceType, String target, String targetType, RelType reltype, Provenance provenance) {
        Relation relation = new Relation();
        relation.source = source;
        relation.sourceType = sourceType;
        relation.target = target;
        relation.targetType = targetType;
        relation.relType = reltype;
        relation.provenance = provenance;
        return relation;
    }
}

