/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.community.CommunityConfigurationFactory;
import eu.dnetlib.dhp.bulktag.community.ProtoMap;
import eu.dnetlib.dhp.bulktag.community.QueryInformationSystem;
import eu.dnetlib.dhp.bulktag.community.ResultTagger;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBulkTagJob {
    private static final Logger log = LoggerFactory.getLogger(SparkBulkTagJob.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)SparkBulkTagJob.class.getResourceAsStream("/eu/dnetlib/dhp/bulktag/input_bulkTag_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        Boolean isTest = Optional.ofNullable(parser.get("isTest")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        log.info("isTest: {} ", (Object)isTest);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        ProtoMap protoMappingParams = (ProtoMap)new Gson().fromJson(parser.get("pathMap"), ProtoMap.class);
        log.info("pathMap: {}", (Object)new Gson().toJson((Object)protoMappingParams));
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        Boolean saveGraph = Optional.ofNullable(parser.get("saveGraph")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("saveGraph: {}", (Object)saveGraph);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkConf conf = new SparkConf();
        String taggingConf = parser.get("taggingConf");
        CommunityConfiguration cc = isTest != false ? CommunityConfigurationFactory.newInstance(taggingConf) : QueryInformationSystem.getCommunityConfiguration(parser.get("isLookUpUrl"));
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            SparkBulkTagJob.execBulkTag(spark, inputPath, outputPath, protoMappingParams, resultClazz, cc);
        });
    }

    private static <R extends Result> void execBulkTag(SparkSession spark, String inputPath, String outputPath, ProtoMap protoMappingParams, Class<R> resultClazz, CommunityConfiguration communityConfiguration) {
        ResultTagger resultTagger = new ResultTagger();
        SparkBulkTagJob.readPath(spark, inputPath, resultClazz).map((MapFunction & Serializable)value -> resultTagger.enrichContextCriteria(value, communityConfiguration, protoMappingParams), Encoders.bean(resultClazz)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

