/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.projecttoresult;

import com.google.gson.Gson;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.countrypropagation.PrepareDatasourceCountryAssociation;
import eu.dnetlib.dhp.projecttoresult.ResultProjectSet;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareProjectResultsAssociation {
    private static final Logger log = LoggerFactory.getLogger(PrepareDatasourceCountryAssociation.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareProjectResultsAssociation.class.getResourceAsStream("/eu/dnetlib/dhp/projecttoresult/input_prepareprojecttoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String potentialUpdatePath = parser.get("potentialUpdatePath");
        log.info("potentialUpdatePath {}: ", (Object)potentialUpdatePath);
        String alreadyLinkedPath = parser.get("alreadyLinkedPath");
        log.info("alreadyLinkedPath: {} ", (Object)alreadyLinkedPath);
        List<String> allowedsemrel = Arrays.asList(parser.get("allowedsemrels").split(";"));
        log.info("allowedSemRel: {}", (Object)new Gson().toJson(allowedsemrel));
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, potentialUpdatePath);
            PropagationConstant.removeOutputDir(spark, alreadyLinkedPath);
            PrepareProjectResultsAssociation.prepareResultProjProjectResults(spark, inputPath, potentialUpdatePath, alreadyLinkedPath, allowedsemrel);
        });
    }

    private static void prepareResultProjProjectResults(SparkSession spark, String inputPath, String potentialUpdatePath, String alreadyLinkedPath, List<String> allowedsemrel) {
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputPath, Relation.class);
        relation.createOrReplaceTempView("relation");
        String resproj_relation_query = "SELECT source, target        FROM relation        WHERE datainfo.deletedbyinference = false        AND relClass = 'isProducedBy'";
        Dataset resproj_relation = spark.sql(resproj_relation_query);
        resproj_relation.createOrReplaceTempView("resproj_relation");
        String potential_update_query = "SELECT resultId, collect_set(projectId) projectSet FROM ( SELECT r1.target resultId, r2.target projectId       FROM (SELECT source, target             FROM relation             WHERE datainfo.deletedbyinference = false  " + PropagationConstant.getConstraintList(" relClass = '", allowedsemrel) + "            ) r1      JOIN resproj_relation r2       ON r1.source = r2.source       ) tmp GROUP BY resultId ";
        spark.sql(potential_update_query).as(Encoders.bean(ResultProjectSet.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(potentialUpdatePath);
        String result_projectset_query = "SELECT source resultId, collect_set(target) projectSet FROM resproj_relation GROUP BY source";
        spark.sql(result_projectset_query).as(Encoders.bean(ResultProjectSet.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(alreadyLinkedPath);
    }
}

