/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.countrypropagation;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.countrypropagation.DatasourceCountry;
import eu.dnetlib.dhp.countrypropagation.ResultCountrySet;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultCountrySet {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCountrySet.class);
    private static final String RESULT_COUNTRYSET_QUERY = "SELECT id resultId, collect_set(country) countrySet FROM ( SELECT id, country FROM datasource_country JOIN cfhb ON cf = dataSourceId UNION ALL SELECT id, country FROM datasource_country JOIN cfhb ON hb = dataSourceId ) tmp GROUP BY id";

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCountrySet.class.getResourceAsStream("/eu/dnetlib/dhp/countrypropagation/input_prepareresultcountry_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String datasourcecountrypath = parser.get("preparedInfoPath");
        log.info("preparedInfoPath: {}", (Object)datasourcecountrypath);
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> PrepareResultCountrySet.getPotentialResultToUpdate(spark, inputPath, outputPath, datasourcecountrypath, resultClazz));
    }

    private static <R extends Result> void getPotentialResultToUpdate(SparkSession spark, String inputPath, String outputPath, String datasourcecountrypath, Class<R> resultClazz) {
        Dataset<R> result = PropagationConstant.readPath(spark, inputPath, resultClazz);
        result.createOrReplaceTempView("result");
        PropagationConstant.createCfHbforResult(spark);
        Dataset<DatasourceCountry> datasource_country = PropagationConstant.readPath(spark, datasourcecountrypath, DatasourceCountry.class);
        datasource_country.createOrReplaceTempView("datasource_country");
        spark.sql(RESULT_COUNTRYSET_QUERY).as(Encoders.bean(ResultCountrySet.class)).write().option("compression", "gzip").mode(SaveMode.Append).json(outputPath);
    }
}

