/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcidtoresultfromsemrel;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.AutoritativeAuthor;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.ResultOrcidList;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkOrcidToResultFromSemRelJob {
    private static final Logger log = LoggerFactory.getLogger(SparkOrcidToResultFromSemRelJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)SparkOrcidToResultFromSemRelJob.class.getResourceAsStream("/eu/dnetlib/dhp/orcidtoresultfromsemrel/input_orcidtoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String possibleUpdates = parser.get("possibleUpdatesPath");
        log.info("possibleUpdatesPath: {}", (Object)possibleUpdates);
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        Boolean saveGraph = Optional.ofNullable(parser.get("saveGraph")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("saveGraph: {}", (Object)saveGraph);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            if (saveGraph.booleanValue()) {
                SparkOrcidToResultFromSemRelJob.execPropagation(spark, possibleUpdates, inputPath, outputPath, resultClazz);
            }
        });
    }

    private static <R extends Result> void execPropagation(SparkSession spark, String possibleUpdatesPath, String inputPath, String outputPath, Class<R> resultClazz) {
        Dataset<ResultOrcidList> possible_updates = PropagationConstant.readPath(spark, possibleUpdatesPath, ResultOrcidList.class);
        Dataset<R> result = PropagationConstant.readPath(spark, inputPath, resultClazz);
        result.joinWith(possible_updates, result.col("id").equalTo((Object)possible_updates.col("resultId")), "left_outer").map(SparkOrcidToResultFromSemRelJob.authorEnrichFn(), Encoders.bean(resultClazz)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    private static <R extends Result> MapFunction<Tuple2<R, ResultOrcidList>, R> authorEnrichFn() {
        return (MapFunction & Serializable)value -> {
            Result ret = (Result)value._1();
            Optional<Object> rol = Optional.ofNullable(value._2());
            if (rol.isPresent()) {
                List toenrich_author = ret.getAuthor();
                List<AutoritativeAuthor> autoritativeAuthors = ((ResultOrcidList)rol.get()).getAuthorList();
                for (Author author : toenrich_author) {
                    if (SparkOrcidToResultFromSemRelJob.containsAllowedPid(author)) continue;
                    SparkOrcidToResultFromSemRelJob.enrichAuthor(author, autoritativeAuthors);
                }
            }
            return ret;
        };
    }

    private static void enrichAuthor(Author a, List<AutoritativeAuthor> au) {
        PacePerson pp = new PacePerson(a.getFullname(), false);
        for (AutoritativeAuthor aa : au) {
            if (!SparkOrcidToResultFromSemRelJob.enrichAuthor(aa, a, pp.getNormalisedFirstName(), pp.getNormalisedSurname())) continue;
            return;
        }
    }

    private static boolean enrichAuthor(AutoritativeAuthor autoritative_author, Author author, String author_name, String author_surname) {
        boolean toaddpid = false;
        if (StringUtils.isNotEmpty((CharSequence)autoritative_author.getSurname())) {
            if (StringUtils.isNotEmpty((CharSequence)author.getSurname())) {
                author_surname = author.getSurname();
            }
            if (StringUtils.isNotEmpty((CharSequence)author_surname) && autoritative_author.getSurname().trim().equalsIgnoreCase(author_surname.trim()) && StringUtils.isNotEmpty((CharSequence)autoritative_author.getName())) {
                if (StringUtils.isNotEmpty((CharSequence)author.getName())) {
                    author_name = author.getName();
                }
                if (StringUtils.isNotEmpty((CharSequence)author_name)) {
                    if (autoritative_author.getName().trim().equalsIgnoreCase(author_name.trim())) {
                        toaddpid = true;
                    } else if (autoritative_author.getName().trim().substring(0, 0).equalsIgnoreCase(author_name.trim().substring(0, 0))) {
                        toaddpid = true;
                    }
                }
            }
        }
        if (toaddpid) {
            StructuredProperty p = new StructuredProperty();
            p.setValue(autoritative_author.getOrcid());
            p.setQualifier(PropagationConstant.getQualifier("ORCID", "ORCID"));
            p.setDataInfo(PropagationConstant.getDataInfo("propagation", "authorpid:result", "Propagation of authors pid to result through semantic relations"));
            Optional<List> authorPid = Optional.ofNullable(author.getPid());
            if (authorPid.isPresent()) {
                authorPid.get().add(p);
            } else {
                author.setPid((List)Lists.newArrayList((Object[])new StructuredProperty[]{p}));
            }
        }
        return toaddpid;
    }

    private static boolean containsAllowedPid(Author a) {
        Optional<List> pids = Optional.ofNullable(a.getPid());
        if (!pids.isPresent()) {
            return false;
        }
        for (StructuredProperty pid : pids.get()) {
            if (!"ORCID".equals(pid.getQualifier().getClassid())) continue;
            return true;
        }
        return false;
    }
}

